/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.child.CustomQueryWrappingFilter;
import org.elasticsearch.index.search.child.DeleteByQueryWrappingFilter;
import org.elasticsearch.index.search.child.ParentConstantScoreQuery;
import org.elasticsearch.index.search.child.ParentQuery;
import org.elasticsearch.search.internal.SearchContext;

public class HasParentQueryParser
implements QueryParser {
    public static final String NAME = "has_parent";

    @Inject
    public HasParentQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        Filter parentFilter;
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query innerQuery = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    String[] stringArray;
                    if (parentType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = parentType;
                    }
                    String[] origTypes = QueryParseContext.setTypesWithPrevious(stringArray);
                    try {
                        innerQuery = parseContext.parseInnerQuery();
                        queryFound = true;
                        continue;
                    }
                    finally {
                        QueryParseContext.setTypes(origTypes);
                        continue;
                    }
                }
                throw new QueryParsingException(parseContext.index(), "[has_parent] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("type".equals(currentFieldName) || "parent_type".equals(currentFieldName) || "parentType".equals(currentFieldName)) {
                parentType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                throw new QueryParsingException(parseContext.index(), "the [_scope] support in [has_parent] query has been removed, use a filter as a facet_filter in the relevant global facet");
            }
            if ("score_type".equals(currentFieldName) || "scoreType".equals(currentFieldName)) {
                String scoreTypeValue = parser.text();
                if ("score".equals(scoreTypeValue)) {
                    score = true;
                    continue;
                }
                if (!"none".equals(scoreTypeValue)) continue;
                score = false;
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                String scoreModeValue = parser.text();
                if ("score".equals(scoreModeValue)) {
                    score = true;
                    continue;
                }
                if (!"none".equals(scoreModeValue)) continue;
                score = false;
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[has_parent] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[has_parent] query requires 'query' field");
        }
        if (innerQuery == null) {
            return null;
        }
        if (parentType == null) {
            throw new QueryParsingException(parseContext.index(), "[has_parent] query requires 'parent_type' field");
        }
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "[has_parent] query configured 'parent_type' [" + parentType + "] is not a valid type");
        }
        innerQuery.setBoost(boost);
        innerQuery = new XFilteredQuery(innerQuery, parseContext.cacheFilter(parentDocMapper.typeFilter(), null));
        HashSet<String> parentTypes = new HashSet<String>(5);
        parentTypes.add(parentType);
        for (DocumentMapper documentMapper : parseContext.mapperService()) {
            DocumentMapper parentTypeDocumentMapper;
            ParentFieldMapper parentFieldMapper = documentMapper.parentFieldMapper();
            if (!parentFieldMapper.active() || (parentTypeDocumentMapper = parseContext.mapperService().documentMapper(parentFieldMapper.type())) != null) continue;
            parentTypes.add(parentFieldMapper.type());
        }
        if (parentTypes.size() == 1) {
            DocumentMapper documentMapper;
            documentMapper = parseContext.mapperService().documentMapper((String)parentTypes.iterator().next());
            parentFilter = parseContext.cacheFilter(documentMapper.typeFilter(), null);
        } else {
            XBooleanFilter parentsFilter = new XBooleanFilter();
            for (String parentTypeStr : parentTypes) {
                DocumentMapper documentMapper = parseContext.mapperService().documentMapper(parentTypeStr);
                Filter filter2 = parseContext.cacheFilter(documentMapper.typeFilter(), null);
                parentsFilter.add(filter2, BooleanClause.Occur.SHOULD);
            }
            parentFilter = parentsFilter;
        }
        Filter childrenFilter = parseContext.cacheFilter(new NotFilter(parentFilter), null);
        boolean deleteByQuery = "delete_by_query".equals(SearchContext.current().source());
        if (!deleteByQuery && score) {
            query = new ParentQuery(innerQuery, parentType, childrenFilter);
        } else {
            query = new ParentConstantScoreQuery(innerQuery, parentType, childrenFilter);
            if (deleteByQuery) {
                query = new XConstantScoreQuery(new DeleteByQueryWrappingFilter(query));
            }
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedFilter(queryName, new CustomQueryWrappingFilter(query));
        }
        return query;
    }
}

