/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class GeohashFilter {
    public static final String NAME = "geohash_cell";
    public static final String NEIGHBORS = "neighbors";
    public static final String PRECISION = "precision";

    public static Filter create(QueryParseContext context, GeoPointFieldMapper fieldMapper, String geohash, @Nullable List<String> geohashes) {
        if (fieldMapper.geoHashStringMapper() == null) {
            throw new ElasticSearchIllegalArgumentException("geohash filter needs geohash_prefix to be enabled");
        }
        StringFieldMapper geoHashMapper = fieldMapper.geoHashStringMapper();
        if (geohashes == null || geohashes.size() == 0) {
            return geoHashMapper.termFilter(geohash, context);
        }
        geohashes.add(geohash);
        return geoHashMapper.termsFilter(geohashes, context);
    }

    public static class Parser
    implements FilterParser {
        @Inject
        public Parser() {
        }

        @Override
        public String[] names() {
            return new String[]{GeohashFilter.NAME, Strings.toCamelCase(GeohashFilter.NAME)};
        }

        @Override
        public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            String geohash = null;
            int levels = -1;
            boolean neighbors = false;
            XContentParser.Token token2 = parser.currentToken();
            if (token2 != XContentParser.Token.START_OBJECT) {
                throw new ElasticSearchParseException("geohash_cell must be an object");
            }
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    String field2 = parser.text();
                    if (GeohashFilter.PRECISION.equals(field2)) {
                        token2 = parser.nextToken();
                        if (token2 == XContentParser.Token.VALUE_NUMBER) {
                            levels = parser.intValue();
                            continue;
                        }
                        if (token2 != XContentParser.Token.VALUE_STRING) continue;
                        double meters = DistanceUnit.parse(parser.text(), DistanceUnit.METERS, DistanceUnit.METERS);
                        levels = GeoUtils.geoHashLevelsForPrecision(meters);
                        continue;
                    }
                    if (GeohashFilter.NEIGHBORS.equals(field2)) {
                        parser.nextToken();
                        neighbors = parser.booleanValue();
                        continue;
                    }
                    fieldName = field2;
                    token2 = parser.nextToken();
                    if (token2 == XContentParser.Token.VALUE_STRING) {
                        String location = parser.text();
                        if (location.indexOf(",") > 0) {
                            geohash = GeoPoint.parse(parser).geohash();
                            continue;
                        }
                        geohash = location;
                        continue;
                    }
                    geohash = GeoPoint.parse(parser).geohash();
                    continue;
                }
                throw new ElasticSearchParseException("unexpected token [" + (Object)((Object)token2) + "]");
            }
            MapperService.SmartNameFieldMappers smartMappers = parseContext.smartFieldMappers(fieldName);
            if (smartMappers == null || !smartMappers.hasMapper()) {
                throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
            }
            FieldMapper mapper = smartMappers.mapper();
            if (!(mapper instanceof GeoPointFieldMapper)) {
                throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
            }
            GeoPointFieldMapper geoMapper = (GeoPointFieldMapper)mapper;
            if (levels > 0) {
                int len = Math.min(levels, geohash.length());
                geohash = geohash.substring(0, len);
            }
            if (neighbors) {
                return GeohashFilter.create(parseContext, geoMapper, geohash, GeoHashUtils.neighbors(geohash));
            }
            return GeohashFilter.create(parseContext, geoMapper, geohash, null);
        }
    }

    public static class Builder
    extends BaseFilterBuilder {
        private String fieldname;
        private String geohash;
        private int levels = -1;
        private boolean neighbors;

        public Builder(String fieldname) {
            this(fieldname, null, false);
        }

        public Builder(String fieldname, GeoPoint point) {
            this(fieldname, point.geohash(), false);
        }

        public Builder(String fieldname, String geohash) {
            this(fieldname, geohash, false);
        }

        public Builder(String fieldname, String geohash, boolean neighbors) {
            this.fieldname = fieldname;
            this.geohash = geohash;
            this.neighbors = neighbors;
        }

        public Builder setPoint(GeoPoint point) {
            this.geohash = point.getGeohash();
            return this;
        }

        public Builder setPoint(double lat, double lon) {
            this.geohash = GeoHashUtils.encode(lat, lon);
            return this;
        }

        public Builder setGeohash(String geohash) {
            this.geohash = geohash;
            return this;
        }

        public Builder setPrecision(int levels) {
            this.levels = levels;
            return this;
        }

        public Builder setPrecision(String precision) {
            double meters = DistanceUnit.parse(precision, DistanceUnit.METERS, DistanceUnit.METERS);
            return this.setPrecision(GeoUtils.geoHashLevelsForPrecision(meters));
        }

        public Builder setNeighbors(boolean neighbors) {
            this.neighbors = neighbors;
            return this;
        }

        public Builder setField(String fieldname) {
            this.fieldname = fieldname;
            return this;
        }

        @Override
        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GeohashFilter.NAME);
            if (this.neighbors) {
                builder.field(GeohashFilter.NEIGHBORS, this.neighbors);
            }
            if (this.levels > 0) {
                builder.field(GeohashFilter.PRECISION, this.levels);
            }
            builder.field(this.fieldname, this.geohash);
            builder.endObject();
        }
    }
}

