/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.elasticsearch.common.geo.GeoJSONShapeSerializer;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class GeoShapeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final Shape shape;
    private SpatialStrategy strategy = null;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapeFieldName;
    private ShapeRelation relation = null;

    public GeoShapeFilterBuilder(String name, Shape shape) {
        this(name, shape, null, null, null);
    }

    public GeoShapeFilterBuilder(String name, Shape shape, ShapeRelation relation) {
        this(name, shape, null, null, relation);
    }

    public GeoShapeFilterBuilder(String name, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this(name, null, indexedShapeId, indexedShapeType, relation);
    }

    private GeoShapeFilterBuilder(String name, Shape shape, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this.name = name;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.relation = relation;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoShapeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public GeoShapeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoShapeFilterBuilder strategy(SpatialStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GeoShapeFilterBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeFilterBuilder indexedShapeFieldName(String indexedShapeFieldName) {
        this.indexedShapeFieldName = indexedShapeFieldName;
        return this;
    }

    public GeoShapeFilterBuilder relation(ShapeRelation relation) {
        this.relation = relation;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        if (this.strategy != null) {
            builder.field("strategy", this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.startObject("shape");
            GeoJSONShapeSerializer.serialize(this.shape, builder);
            builder.endObject();
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapeFieldName != null) {
                builder.field("shape_field_name", this.indexedShapeFieldName);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field("relation", this.relation.getRelationName());
        }
        builder.endObject();
        if (this.name != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

