/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.GeoDistanceRangeFilter;

public class GeoDistanceRangeFilterParser
implements FilterParser {
    public static final String NAME = "geo_distance_range";

    @Inject
    public GeoDistanceRangeFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoDistanceRange"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint();
        String fieldName = null;
        Object vFrom = null;
        Object vTo = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        String optimizeBbox = "memory";
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                token2 = parser.nextToken();
                double lon = parser.doubleValue();
                token2 = parser.nextToken();
                double lat = parser.doubleValue();
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                point.reset(lat, lon);
                fieldName = currentFieldName;
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token2.isValue()) continue;
                    if (currentName.equals("lat")) {
                        point.resetLat(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        point.resetLon(parser.doubleValue());
                        continue;
                    }
                    if (!currentName.equals("geohash")) continue;
                    GeoHashUtils.decode(parser.text(), point);
                }
                continue;
            }
            if (!token2.isValue()) continue;
            if (currentFieldName.equals("from")) {
                if (token2 == XContentParser.Token.VALUE_NULL) continue;
                if (token2 == XContentParser.Token.VALUE_STRING) {
                    vFrom = parser.text();
                    continue;
                }
                vFrom = parser.numberValue();
                continue;
            }
            if (currentFieldName.equals("to")) {
                if (token2 == XContentParser.Token.VALUE_NULL) continue;
                if (token2 == XContentParser.Token.VALUE_STRING) {
                    vTo = parser.text();
                    continue;
                }
                vTo = parser.numberValue();
                continue;
            }
            if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if ("gt".equals(currentFieldName)) {
                if (token2 != XContentParser.Token.VALUE_NULL) {
                    vFrom = token2 == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = false;
                continue;
            }
            if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                if (token2 != XContentParser.Token.VALUE_NULL) {
                    vFrom = token2 == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = true;
                continue;
            }
            if ("lt".equals(currentFieldName)) {
                if (token2 != XContentParser.Token.VALUE_NULL) {
                    vTo = token2 == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = false;
                continue;
            }
            if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                if (token2 != XContentParser.Token.VALUE_NULL) {
                    vTo = token2 == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = true;
                continue;
            }
            if (currentFieldName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentFieldName.equals("distance_type") || currentFieldName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (currentFieldName.endsWith(".geohash")) {
                GeoHashUtils.decode(parser.text(), point);
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".geohash".length());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("optimize_bbox".equals(currentFieldName) || "optimizeBbox".equals(currentFieldName)) {
                optimizeBbox = parser.textOrNull();
                continue;
            }
            if ("normalize".equals(currentFieldName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            point.resetFromString(parser.text());
            fieldName = currentFieldName;
        }
        Double from2 = null;
        Double to2 = null;
        if (vFrom != null) {
            from2 = vFrom instanceof Number ? Double.valueOf(unit.toMiles(((Number)vFrom).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vFrom, unit, DistanceUnit.MILES));
            from2 = geoDistance.normalize(from2, DistanceUnit.MILES);
        }
        if (vTo != null) {
            to2 = vTo instanceof Number ? Double.valueOf(unit.toMiles(((Number)vTo).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vTo, unit, DistanceUnit.MILES));
            to2 = geoDistance.normalize(to2, DistanceUnit.MILES);
        }
        if (normalizeLat || normalizeLon) {
            GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (!(mapper instanceof GeoPointFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        GeoPointFieldMapper geoMapper = (GeoPointFieldMapper)mapper;
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.fieldData().getForField(mapper);
        Filter filter2 = new GeoDistanceRangeFilter(point, from2, to2, includeLower, includeUpper, geoDistance, geoMapper, indexFieldData, optimizeBbox);
        if (cache) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter2);
        }
        return filter2;
    }
}

