/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;

public class FuzzyQueryBuilder
extends BaseQueryBuilder
implements MultiTermQueryBuilder,
BoostableQueryBuilder<FuzzyQueryBuilder> {
    private final String name;
    private final Object value;
    private float boost = -1.0f;
    private String minSimilarity;
    private Integer prefixLength;
    private Integer maxExpansions;
    private Boolean transpositions;
    private String queryName;

    public FuzzyQueryBuilder(String name, Object value2) {
        this.name = name;
        this.value = value2;
    }

    @Override
    public FuzzyQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public FuzzyQueryBuilder minSimilarity(float defaultMinSimilarity) {
        this.minSimilarity = Float.toString(defaultMinSimilarity);
        return this;
    }

    public FuzzyQueryBuilder minSimilarity(String defaultMinSimilarity) {
        this.minSimilarity = defaultMinSimilarity;
        return this;
    }

    public FuzzyQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public FuzzyQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public FuzzyQueryBuilder transpositions(boolean transpositions) {
        this.transpositions = transpositions;
        return this;
    }

    public FuzzyQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("fuzzy");
        if (this.boost == -1.0f && this.minSimilarity == null && this.prefixLength == null && this.queryName != null) {
            builder.field(this.name, this.value);
        } else {
            builder.startObject(this.name);
            builder.field("value", this.value);
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.transpositions != null) {
                builder.field("transpositions", (Object)this.transpositions);
            }
            if (this.minSimilarity != null) {
                builder.field("min_similarity", this.minSimilarity);
            }
            if (this.prefixLength != null) {
                builder.field("prefix_length", this.prefixLength);
            }
            if (this.maxExpansions != null) {
                builder.field("max_expansions", this.maxExpansions);
            }
            if (this.queryName != null) {
                builder.field("_name", this.queryName);
            }
            builder.endObject();
        }
        builder.endObject();
    }
}

