/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class FuzzyLikeThisFieldQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<FuzzyLikeThisFieldQueryBuilder> {
    private final String name;
    private Float boost;
    private String likeText = null;
    private Float minSimilarity;
    private Integer prefixLength;
    private Integer maxQueryTerms;
    private Boolean ignoreTF;
    private String analyzer;
    private Boolean failOnUnsupportedField;
    private String queryName;

    public FuzzyLikeThisFieldQueryBuilder(String name) {
        this.name = name;
    }

    public FuzzyLikeThisFieldQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder minSimilarity(float minSimilarity) {
        this.minSimilarity = Float.valueOf(minSimilarity);
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder ignoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public FuzzyLikeThisFieldQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public FuzzyLikeThisFieldQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("flt_field");
        builder.startObject(this.name);
        if (this.likeText == null) {
            throw new ElasticSearchIllegalArgumentException("fuzzyLikeThis requires 'likeText' to be provided");
        }
        builder.field("like_text", this.likeText);
        if (this.maxQueryTerms != null) {
            builder.field("max_query_terms", this.maxQueryTerms);
        }
        if (this.minSimilarity != null) {
            builder.field("min_similarity", this.minSimilarity);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.ignoreTF != null) {
            builder.field("ignore_tf", (Object)this.ignoreTF);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field("fail_on_unsupported_field", (Object)this.failOnUnsupportedField);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

