/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FilteredQueryParser
implements QueryParser {
    public static final String NAME = "filtered";

    @Inject
    public FilteredQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query query = Queries.newMatchAllQuery();
        Filter filter2 = null;
        boolean filterFound = false;
        float boost = 1.0f;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String queryName = null;
        String currentFieldName = null;
        FilteredQuery.FilterStrategy filterStrategy = XFilteredQuery.CUSTOM_FILTER_STRATEGY;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    filterFound = true;
                    filter2 = parseContext.parseInnerFilter();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[filtered] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("strategy".equals(currentFieldName)) {
                int threshold;
                String value2 = parser.text();
                if ("query_first".equals(value2) || "queryFirst".equals(value2)) {
                    filterStrategy = FilteredQuery.QUERY_FIRST_FILTER_STRATEGY;
                    continue;
                }
                if ("random_access_always".equals(value2) || "randomAccessAlways".equals(value2)) {
                    filterStrategy = XFilteredQuery.ALWAYS_RANDOM_ACCESS_FILTER_STRATEGY;
                    continue;
                }
                if ("leap_frog".equals(value2) || "leapFrog".equals(value2)) {
                    filterStrategy = FilteredQuery.LEAP_FROG_QUERY_FIRST_STRATEGY;
                    continue;
                }
                if (value2.startsWith("random_access_")) {
                    threshold = Integer.parseInt(value2.substring("random_access_".length()));
                    filterStrategy = new XFilteredQuery.CustomRandomAccessFilterStrategy(threshold);
                    continue;
                }
                if (value2.startsWith("randomAccess")) {
                    threshold = Integer.parseInt(value2.substring("randomAccess".length()));
                    filterStrategy = new XFilteredQuery.CustomRandomAccessFilterStrategy(threshold);
                    continue;
                }
                if ("leap_frog_query_first".equals(value2) || "leapFrogQueryFirst".equals(value2)) {
                    filterStrategy = FilteredQuery.LEAP_FROG_QUERY_FIRST_STRATEGY;
                    continue;
                }
                if ("leap_frog_filter_first".equals(value2) || "leapFrogFilterFirst".equals(value2)) {
                    filterStrategy = FilteredQuery.LEAP_FROG_FILTER_FIRST_STRATEGY;
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[filtered] strategy value not supported [" + value2 + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[filtered] query does not support [" + currentFieldName + "]");
        }
        if (query == null) {
            return null;
        }
        if (filter2 == null) {
            if (!filterFound) {
                return query;
            }
            return query;
        }
        if (filter2 == Queries.MATCH_ALL_FILTER) {
            return query;
        }
        if (cache) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        if (Queries.isConstantMatchAllQuery(query)) {
            XConstantScoreQuery q = new XConstantScoreQuery(filter2);
            q.setBoost(boost);
            return q;
        }
        XFilteredQuery filteredQuery = new XFilteredQuery(query, filter2, filterStrategy);
        filteredQuery.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, filteredQuery);
        }
        return filteredQuery;
    }
}

