/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxFilterBuilder;
import org.elasticsearch.index.query.GeoDistanceFilterBuilder;
import org.elasticsearch.index.query.GeoDistanceRangeFilterBuilder;
import org.elasticsearch.index.query.GeoPolygonFilterBuilder;
import org.elasticsearch.index.query.GeoShapeFilterBuilder;
import org.elasticsearch.index.query.GeohashFilter;
import org.elasticsearch.index.query.HasChildFilterBuilder;
import org.elasticsearch.index.query.HasParentFilterBuilder;
import org.elasticsearch.index.query.IdsFilterBuilder;
import org.elasticsearch.index.query.IndicesFilterBuilder;
import org.elasticsearch.index.query.LimitFilterBuilder;
import org.elasticsearch.index.query.MatchAllFilterBuilder;
import org.elasticsearch.index.query.MissingFilterBuilder;
import org.elasticsearch.index.query.NestedFilterBuilder;
import org.elasticsearch.index.query.NotFilterBuilder;
import org.elasticsearch.index.query.NumericRangeFilterBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.PrefixFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryFilterBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.RegexpFilterBuilder;
import org.elasticsearch.index.query.ScriptFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.index.query.TermsLookupFilterBuilder;
import org.elasticsearch.index.query.TypeFilterBuilder;
import org.elasticsearch.index.query.WrapperFilterBuilder;

public abstract class FilterBuilders {
    public static MatchAllFilterBuilder matchAllFilter() {
        return new MatchAllFilterBuilder();
    }

    public static LimitFilterBuilder limitFilter(int limit) {
        return new LimitFilterBuilder(limit);
    }

    public static NestedFilterBuilder nestedFilter(String path, QueryBuilder query) {
        return new NestedFilterBuilder(path, query);
    }

    public static NestedFilterBuilder nestedFilter(String path, FilterBuilder filter2) {
        return new NestedFilterBuilder(path, filter2);
    }

    public static IdsFilterBuilder idsFilter(String ... types) {
        return new IdsFilterBuilder(types);
    }

    public static TypeFilterBuilder typeFilter(String type) {
        return new TypeFilterBuilder(type);
    }

    public static TermFilterBuilder termFilter(String name, String value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermFilterBuilder termFilter(String name, int value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermFilterBuilder termFilter(String name, long value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermFilterBuilder termFilter(String name, float value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermFilterBuilder termFilter(String name, double value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermFilterBuilder termFilter(String name, Object value2) {
        return new TermFilterBuilder(name, value2);
    }

    public static TermsFilterBuilder termsFilter(String name, String ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, int ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, long ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, float ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, double ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, Object ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder termsFilter(String name, Iterable<?> values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsLookupFilterBuilder termsLookupFilter(String name) {
        return new TermsLookupFilterBuilder(name);
    }

    public static TermsFilterBuilder inFilter(String name, String ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder inFilter(String name, int ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder inFilter(String name, long ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder inFilter(String name, float ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder inFilter(String name, double ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static TermsFilterBuilder inFilter(String name, Object ... values2) {
        return new TermsFilterBuilder(name, values2);
    }

    public static PrefixFilterBuilder prefixFilter(String name, String prefix) {
        return new PrefixFilterBuilder(name, prefix);
    }

    public static RegexpFilterBuilder regexpFilter(String name, String regexp) {
        return new RegexpFilterBuilder(name, regexp);
    }

    public static RangeFilterBuilder rangeFilter(String name) {
        return new RangeFilterBuilder(name);
    }

    @Deprecated
    public static NumericRangeFilterBuilder numericRangeFilter(String name) {
        return new NumericRangeFilterBuilder(name);
    }

    public static QueryFilterBuilder queryFilter(QueryBuilder queryBuilder) {
        return new QueryFilterBuilder(queryBuilder);
    }

    public static ScriptFilterBuilder scriptFilter(String script) {
        return new ScriptFilterBuilder(script);
    }

    public static GeoDistanceFilterBuilder geoDistanceFilter(String name) {
        return new GeoDistanceFilterBuilder(name);
    }

    public static GeoDistanceRangeFilterBuilder geoDistanceRangeFilter(String name) {
        return new GeoDistanceRangeFilterBuilder(name);
    }

    public static GeoBoundingBoxFilterBuilder geoBoundingBoxFilter(String name) {
        return new GeoBoundingBoxFilterBuilder(name);
    }

    public static GeohashFilter.Builder geoHashFilter(String fieldname) {
        return new GeohashFilter.Builder(fieldname);
    }

    public static GeohashFilter.Builder geoHashFilter(String fieldname, String geohash) {
        return new GeohashFilter.Builder(fieldname, geohash);
    }

    public static GeohashFilter.Builder geoHashFilter(String fieldname, GeoPoint point) {
        return new GeohashFilter.Builder(fieldname, point);
    }

    public static GeohashFilter.Builder geoHashFilter(String fieldname, String geohash, boolean neighbors) {
        return new GeohashFilter.Builder(fieldname, geohash, neighbors);
    }

    public static GeoPolygonFilterBuilder geoPolygonFilter(String name) {
        return new GeoPolygonFilterBuilder(name);
    }

    public static GeoShapeFilterBuilder geoShapeFilter(String name, Shape shape, ShapeRelation relation) {
        return new GeoShapeFilterBuilder(name, shape, relation);
    }

    public static GeoShapeFilterBuilder geoShapeFilter(String name, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        return new GeoShapeFilterBuilder(name, indexedShapeId, indexedShapeType, relation);
    }

    public static GeoShapeFilterBuilder geoIntersectionFilter(String name, Shape shape) {
        return FilterBuilders.geoShapeFilter(name, shape, ShapeRelation.INTERSECTS);
    }

    public static GeoShapeFilterBuilder geoIntersectionFilter(String name, String indexedShapeId, String indexedShapeType) {
        return FilterBuilders.geoShapeFilter(name, indexedShapeId, indexedShapeType, ShapeRelation.INTERSECTS);
    }

    public static GeoShapeFilterBuilder geoWithinFilter(String name, Shape shape) {
        return FilterBuilders.geoShapeFilter(name, shape, ShapeRelation.WITHIN);
    }

    public static GeoShapeFilterBuilder geoWithinFilter(String name, String indexedShapeId, String indexedShapeType) {
        return FilterBuilders.geoShapeFilter(name, indexedShapeId, indexedShapeType, ShapeRelation.WITHIN);
    }

    public static GeoShapeFilterBuilder geoDisjointFilter(String name, Shape shape) {
        return FilterBuilders.geoShapeFilter(name, shape, ShapeRelation.DISJOINT);
    }

    public static GeoShapeFilterBuilder geoDisjointFilter(String name, String indexedShapeId, String indexedShapeType) {
        return FilterBuilders.geoShapeFilter(name, indexedShapeId, indexedShapeType, ShapeRelation.DISJOINT);
    }

    public static ExistsFilterBuilder existsFilter(String name) {
        return new ExistsFilterBuilder(name);
    }

    public static MissingFilterBuilder missingFilter(String name) {
        return new MissingFilterBuilder(name);
    }

    public static HasChildFilterBuilder hasChildFilter(String type, QueryBuilder query) {
        return new HasChildFilterBuilder(type, query);
    }

    public static HasChildFilterBuilder hasChildFilter(String type, FilterBuilder filter2) {
        return new HasChildFilterBuilder(type, filter2);
    }

    public static HasParentFilterBuilder hasParentFilter(String parentType, QueryBuilder query) {
        return new HasParentFilterBuilder(parentType, query);
    }

    public static HasParentFilterBuilder hasParentFilter(String parentType, FilterBuilder filter2) {
        return new HasParentFilterBuilder(parentType, filter2);
    }

    public static BoolFilterBuilder boolFilter() {
        return new BoolFilterBuilder();
    }

    public static AndFilterBuilder andFilter(FilterBuilder ... filters) {
        return new AndFilterBuilder(filters);
    }

    public static OrFilterBuilder orFilter(FilterBuilder ... filters) {
        return new OrFilterBuilder(filters);
    }

    public static NotFilterBuilder notFilter(FilterBuilder filter2) {
        return new NotFilterBuilder(filter2);
    }

    public static IndicesFilterBuilder indicesFilter(FilterBuilder filter2, String ... indices) {
        return new IndicesFilterBuilder(filter2, indices);
    }

    public static WrapperFilterBuilder wrapperFilter(String filter2) {
        return new WrapperFilterBuilder(filter2);
    }

    public static WrapperFilterBuilder wrapperFilter(byte[] data2, int offset, int length) {
        return new WrapperFilterBuilder(data2, offset, length);
    }

    private FilterBuilders() {
    }
}

