/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FieldMaskingSpanQueryParser
implements QueryParser {
    public static final String NAME = "field_masking_span";

    @Inject
    public FieldMaskingSpanQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery inner2 = null;
        String field2 = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    Query query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext.index(), "[field_masking_span] query] must be of type span query");
                    }
                    inner2 = (SpanQuery)query;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[field_masking_span] query does not support [" + currentFieldName + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[field_masking_span] query does not support [" + currentFieldName + "]");
        }
        if (inner2 == null) {
            throw new QueryParsingException(parseContext.index(), "field_masking_span must have [query] span query clause");
        }
        if (field2 == null) {
            throw new QueryParsingException(parseContext.index(), "field_masking_span must have [field] set for it");
        }
        FieldMapper mapper = parseContext.fieldMapper(field2);
        if (mapper != null) {
            field2 = mapper.names().indexName();
        }
        FieldMaskingSpanQuery query = new FieldMaskingSpanQuery(inner2, field2);
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

