/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.SearchScript;

public class CustomScoreQueryParser
implements QueryParser {
    public static final String NAME = "custom_score";

    @Inject
    public CustomScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        SearchScript searchScript;
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query query = null;
        Filter filter2 = null;
        boolean queryOrFilterFound = false;
        float boost = 1.0f;
        String script = null;
        String scriptLang = null;
        Map<String, Object> vars = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    queryOrFilterFound = true;
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    filter2 = parseContext.parseInnerFilter();
                    queryOrFilterFound = true;
                    continue;
                }
                if ("params".equals(currentFieldName)) {
                    vars = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_score] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[custom_score] query does not support [" + currentFieldName + "]");
        }
        if (!queryOrFilterFound) {
            throw new QueryParsingException(parseContext.index(), "[custom_score] requires 'query' or 'filter' field");
        }
        if (script == null) {
            throw new QueryParsingException(parseContext.index(), "[custom_score] requires 'script' field");
        }
        if (query == null && filter2 == null) {
            return null;
        }
        if (filter2 != null) {
            query = new XConstantScoreQuery(filter2);
        }
        try {
            searchScript = parseContext.scriptService().search(parseContext.lookup(), scriptLang, script, vars);
        }
        catch (Exception e) {
            throw new QueryParsingException(parseContext.index(), "[custom_score] the script could not be loaded", e);
        }
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(query, new ScriptScoreFunction(script, vars, searchScript));
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }
}

