/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hppc.FloatArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.SearchScript;

public class CustomFiltersScoreQueryParser
implements QueryParser {
    public static final String NAME = "custom_filters_score";

    @Inject
    public CustomFiltersScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query query = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String scriptLang = null;
        Map<String, Object> vars = null;
        FiltersFunctionScoreQuery.ScoreMode scoreMode = FiltersFunctionScoreQuery.ScoreMode.First;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        boolean filtersFound = false;
        ArrayList<String> scripts = new ArrayList<String>();
        FloatArrayList boosts = new FloatArrayList();
        float maxBoost = Float.MAX_VALUE;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    queryFound = true;
                    continue;
                }
                if ("params".equals(currentFieldName)) {
                    vars = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_filters_score] query does not support [" + currentFieldName + "]");
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("filters".equals(currentFieldName)) {
                    filtersFound = true;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String script = null;
                        Filter filter2 = null;
                        boolean filterFound = false;
                        float fboost = Float.NaN;
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token2 == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token2 == XContentParser.Token.START_OBJECT) {
                                if (!"filter".equals(currentFieldName)) continue;
                                filter2 = parseContext.parseInnerFilter();
                                filterFound = true;
                                continue;
                            }
                            if (!token2.isValue()) continue;
                            if ("script".equals(currentFieldName)) {
                                script = parser.text();
                                continue;
                            }
                            if (!"boost".equals(currentFieldName)) continue;
                            fboost = parser.floatValue();
                        }
                        if (script == null && fboost == -1.0f) {
                            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] missing 'script' or 'boost' in filters array element");
                        }
                        if (!filterFound) {
                            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] missing 'filter' in filters array element");
                        }
                        if (filter2 == null) continue;
                        filters.add(filter2);
                        scripts.add(script);
                        boosts.add(fboost);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_filters_score] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                String sScoreMode = parser.text();
                if ("avg".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.Avg;
                    continue;
                }
                if ("max".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.Max;
                    continue;
                }
                if ("min".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.Min;
                    continue;
                }
                if ("total".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.Sum;
                    continue;
                }
                if ("multiply".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.Multiply;
                    continue;
                }
                if ("first".equals(sScoreMode)) {
                    scoreMode = FiltersFunctionScoreQuery.ScoreMode.First;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_filters_score] illegal score_mode [" + sScoreMode + "]");
            }
            if ("max_boost".equals(currentFieldName) || "maxBoost".equals(currentFieldName)) {
                maxBoost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] requires 'query' field");
        }
        if (query == null) {
            return null;
        }
        if (!filtersFound) {
            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] requires 'filters' field");
        }
        if (filters.isEmpty()) {
            return query;
        }
        FiltersFunctionScoreQuery.FilterFunction[] filterFunctions = new FiltersFunctionScoreQuery.FilterFunction[filters.size()];
        for (int i = 0; i < filterFunctions.length; ++i) {
            ScoreFunction scoreFunction;
            String script = (String)scripts.get(i);
            if (script != null) {
                SearchScript searchScript = parseContext.scriptService().search(parseContext.lookup(), scriptLang, script, vars);
                scoreFunction = new ScriptScoreFunction(script, vars, searchScript);
            } else {
                scoreFunction = new BoostScoreFunction(boosts.get(i));
            }
            filterFunctions[i] = new FiltersFunctionScoreQuery.FilterFunction((Filter)filters.get(i), scoreFunction);
        }
        FiltersFunctionScoreQuery functionScoreQuery = new FiltersFunctionScoreQuery(query, scoreMode, filterFunctions, maxBoost);
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }
}

