/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class CustomBoostFactorQueryParser
implements QueryParser {
    public static final String NAME = "custom_boost_factor";

    @Inject
    public CustomBoostFactorQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query query = null;
        boolean queryFound = false;
        float boost = 1.0f;
        float boostFactor = 1.0f;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    queryFound = true;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_boost_factor] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("boost_factor".equals(currentFieldName) || "boostFactor".equals(currentFieldName)) {
                boostFactor = parser.floatValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[custom_boost_factor] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[constant_factor_query] requires 'query' element");
        }
        if (query == null) {
            return null;
        }
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(query, new BoostScoreFunction(boostFactor));
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }
}

