/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class ConstantScoreQueryParser
implements QueryParser {
    public static final String NAME = "constant_score";

    @Inject
    public ConstantScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Filter filter2 = null;
        boolean filterFound = false;
        Query query = null;
        boolean queryFound = false;
        float boost = 1.0f;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("filter".equals(currentFieldName)) {
                    filter2 = parseContext.parseInnerFilter();
                    filterFound = true;
                    continue;
                }
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    queryFound = true;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[constant_score] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[constant_score] query does not support [" + currentFieldName + "]");
        }
        if (!filterFound && !queryFound) {
            throw new QueryParsingException(parseContext.index(), "[constant_score] requires either 'filter' or 'query' element");
        }
        if (query == null && filter2 == null) {
            return null;
        }
        if (filter2 != null) {
            if (cache) {
                filter2 = parseContext.cacheFilter(filter2, cacheKey);
            }
            XConstantScoreQuery query1 = new XConstantScoreQuery(filter2);
            query1.setBoost(boost);
            return query1;
        }
        query = new ConstantScoreQuery(query);
        query.setBoost(boost);
        return query;
    }
}

