/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.queries.BoostingQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class BoostingQueryParser
implements QueryParser {
    public static final String NAME = "boosting";

    @Inject
    public BoostingQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Query positiveQuery = null;
        boolean positiveQueryFound = false;
        Query negativeQuery = null;
        boolean negativeQueryFound = false;
        float boost = -1.0f;
        float negativeBoost = -1.0f;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("positive".equals(currentFieldName)) {
                    positiveQuery = parseContext.parseInnerQuery();
                    positiveQueryFound = true;
                    continue;
                }
                if ("negative".equals(currentFieldName)) {
                    negativeQuery = parseContext.parseInnerQuery();
                    negativeQueryFound = true;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[boosting] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("negative_boost".equals(currentFieldName) || "negativeBoost".equals(currentFieldName)) {
                negativeBoost = parser.floatValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[boosting] query does not support [" + currentFieldName + "]");
        }
        if (positiveQuery == null && !positiveQueryFound) {
            throw new QueryParsingException(parseContext.index(), "[boosting] query requires 'positive' query to be set'");
        }
        if (negativeQuery == null && !negativeQueryFound) {
            throw new QueryParsingException(parseContext.index(), "[boosting] query requires 'negative' query to be set'");
        }
        if (negativeBoost == -1.0f) {
            throw new QueryParsingException(parseContext.index(), "[boosting] query requires 'negative_boost' to be set'");
        }
        if (positiveQuery == null || negativeQuery == null) {
            return null;
        }
        BoostingQuery boostingQuery = new BoostingQuery(positiveQuery, negativeQuery, negativeBoost);
        if (boost != -1.0f) {
            boostingQuery.setBoost(boost);
        }
        return boostingQuery;
    }
}

