/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.queries.FilterClause;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class BoolFilterParser
implements FilterParser {
    public static final String NAME = "bool";

    @Inject
    public BoolFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter2;
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        XBooleanFilter boolFilter = new XBooleanFilter();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        boolean hasAnyFilter = false;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("must".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    filter2 = parseContext.parseInnerFilter();
                    if (filter2 == null) continue;
                    boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.MUST));
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    filter2 = parseContext.parseInnerFilter();
                    if (filter2 == null) continue;
                    boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.MUST_NOT));
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    filter2 = parseContext.parseInnerFilter();
                    if (filter2 == null) continue;
                    boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.SHOULD));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[bool] filter does not support [" + currentFieldName + "]");
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("must".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filter2 = parseContext.parseInnerFilter();
                        if (filter2 == null) continue;
                        boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.MUST));
                    }
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filter2 = parseContext.parseInnerFilter();
                        if (filter2 == null) continue;
                        boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.MUST_NOT));
                    }
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    hasAnyFilter = true;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filter2 = parseContext.parseInnerFilter();
                        if (filter2 == null) continue;
                        boolFilter.add(new FilterClause(filter2, BooleanClause.Occur.SHOULD));
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[bool] filter does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[bool] filter does not support [" + currentFieldName + "]");
        }
        if (!hasAnyFilter) {
            throw new QueryParsingException(parseContext.index(), "[bool] filter has no inner should/must/must_not elements");
        }
        if (boolFilter.clauses().isEmpty()) {
            return null;
        }
        filter2 = boolFilter;
        if (cache) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter2);
        }
        return filter2;
    }
}

