/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;

public class BoolFilterBuilder
extends BaseFilterBuilder {
    private ArrayList<FilterBuilder> mustClauses = new ArrayList();
    private ArrayList<FilterBuilder> mustNotClauses = new ArrayList();
    private ArrayList<FilterBuilder> shouldClauses = new ArrayList();
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public BoolFilterBuilder must(FilterBuilder filterBuilder) {
        this.mustClauses.add(filterBuilder);
        return this;
    }

    public BoolFilterBuilder mustNot(FilterBuilder filterBuilder) {
        this.mustNotClauses.add(filterBuilder);
        return this;
    }

    public BoolFilterBuilder should(FilterBuilder filterBuilder) {
        this.shouldClauses.add(filterBuilder);
        return this;
    }

    public BoolFilterBuilder must(FilterBuilder ... filterBuilders) {
        for (FilterBuilder fb : filterBuilders) {
            this.mustClauses.add(fb);
        }
        return this;
    }

    public BoolFilterBuilder mustNot(FilterBuilder ... filterBuilders) {
        for (FilterBuilder fb : filterBuilders) {
            this.mustNotClauses.add(fb);
        }
        return this;
    }

    public BoolFilterBuilder should(FilterBuilder ... filterBuilders) {
        for (FilterBuilder fb : filterBuilders) {
            this.shouldClauses.add(fb);
        }
        return this;
    }

    public BoolFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public BoolFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public BoolFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("bool");
        this.doXArrayContent("must", this.mustClauses, builder, params);
        this.doXArrayContent("must_not", this.mustNotClauses, builder, params);
        this.doXArrayContent("should", this.shouldClauses, builder, params);
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }

    private void doXArrayContent(String field2, List<FilterBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        if (clauses.size() == 1) {
            builder.field(field2);
            clauses.get(0).toXContent(builder, params);
        } else {
            builder.startArray(field2);
            for (FilterBuilder clause : clauses) {
                clause.toXContent(builder, params);
            }
            builder.endArray();
        }
    }
}

