/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.ReusableMemoryIndex;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.percolator.PercolateIndexUnavailable;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;

public class PercolatorExecutor
extends AbstractIndexComponent {
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final IndexFieldDataService fieldDataService;
    private final Map<String, Query> queries = ConcurrentCollections.newConcurrentMap();
    public static final String PERCOLATE_POOL_SIZE = "index.percolate.pool.size";
    public static final String PERCOLATE_POOL_MAX_MEMORY = "index.percolate.pool.reuse_memory_size";
    public static final String PERCOLATE_TIMEOUT = "index.percolate.pool.timeout";
    private IndicesService indicesService;
    private final MemoryIndexPool memIndexPool;

    @Inject
    public PercolatorExecutor(Index index, @IndexSettings Settings indexSettings, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexFieldDataService fieldDataService, IndexSettingsService indexSettingsService) {
        super(index, indexSettings);
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.fieldDataService = fieldDataService;
        this.memIndexPool = new MemoryIndexPool(indexSettings);
        ApplySettings applySettings = new ApplySettings();
        indexSettingsService.addListener(applySettings);
    }

    public void setIndicesService(IndicesService indicesService) {
        this.indicesService = indicesService;
    }

    public void close() {
        this.queries.clear();
    }

    public void addQuery(String name, QueryBuilder queryBuilder) throws ElasticSearchException {
        try {
            XContentBuilder builder = XContentFactory.smileBuilder().startObject().field("query", queryBuilder).endObject();
            this.addQuery(name, builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to add query [" + name + "]", e);
        }
    }

    public void addQuery(String name, BytesReference source) throws ElasticSearchException {
        this.addQuery(name, this.parseQuery(name, source));
    }

    public Query parseQuery(String name, BytesReference source) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            parser = XContentHelper.createParser(source);
            Query query = null;
            String currentFieldName = null;
            XContentParser.Token token2 = parser.nextToken();
            if (token2 != XContentParser.Token.START_OBJECT) {
                throw new ElasticSearchException("failed to parse query [" + name + "], not starting with OBJECT");
            }
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        query = this.queryParserService.parse(parser).query();
                        break;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token2 != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
            }
            Query query2 = query;
            return query2;
        }
        catch (Exception e) {
            throw new ElasticSearchException("failed to parse query [" + name + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void addQuery(String name, Query query) {
        Preconditions.checkArgument(query != null, "query must be provided for percolate request");
        this.queries.put(name, query);
    }

    public void removeQuery(String name) {
        this.queries.remove(name);
    }

    public void addQueries(Map<String, Query> queries) {
        this.queries.putAll(queries);
    }

    public Response percolate(SourceRequest request) throws ElasticSearchException {
        Query query = null;
        ParsedDocument doc = null;
        XContentParser parser = null;
        try {
            XContentParser.Token token2;
            parser = XContentFactory.xContent(request.source()).createParser(request.source());
            String currentFieldName = null;
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (!"doc".equals(currentFieldName)) continue;
                    DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(request.type());
                    doc = docMapper.parse(SourceToParse.source(parser).type(request.type()).flyweight(true));
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    if (!"query".equals(currentFieldName)) continue;
                    query = this.percolatorIndexServiceSafe().queryParserService().parse(parser).query();
                    continue;
                }
                if (token2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new PercolatorException(this.index, "failed to parse request", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        if (doc == null) {
            throw new PercolatorException(this.index, "No doc to percolate in the request");
        }
        return this.percolate(new DocAndQueryRequest(doc, query));
    }

    public Response percolate(DocAndSourceQueryRequest request) throws ElasticSearchException {
        Query query = null;
        if (Strings.hasLength(request.query()) && !request.query().equals("*")) {
            query = this.percolatorIndexServiceSafe().queryParserService().parse(QueryBuilders.queryString(request.query())).query();
        }
        return this.percolate(new DocAndQueryRequest(request.doc(), query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response percolate(DocAndQueryRequest request) throws ElasticSearchException {
        ReusableMemoryIndex memoryIndex = this.memIndexPool.acquire();
        try {
            ArrayList<String> matches2;
            block19: {
                for (IndexableField field2 : request.doc().rootDoc().getFields()) {
                    if (!field2.fieldType().indexed() || field2.name().equals(UidFieldMapper.NAME)) continue;
                    try {
                        TokenStream tokenStream = field2.tokenStream(request.doc().analyzer());
                        if (tokenStream == null) continue;
                        memoryIndex.addField(field2.name(), tokenStream, field2.boost());
                    }
                    catch (IOException e) {
                        throw new ElasticSearchException("Failed to create token stream", e);
                    }
                }
                IndexSearcher searcher = memoryIndex.createSearcher();
                matches2 = new ArrayList<String>();
                try {
                    if (request.query() == null) {
                        Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
                        for (Map.Entry<String, Query> entry2 : this.queries.entrySet()) {
                            collector.reset();
                            try {
                                searcher.search(entry2.getValue(), collector);
                            }
                            catch (IOException e) {
                                this.logger.warn("[" + entry2.getKey() + "] failed to execute query", e, new Object[0]);
                            }
                            if (!collector.exists()) continue;
                            matches2.add(entry2.getKey());
                        }
                        break block19;
                    }
                    IndexService percolatorIndex = this.percolatorIndexServiceSafe();
                    if (percolatorIndex.numberOfShards() == 0) {
                        throw new PercolateIndexUnavailable(new Index("_percolator"));
                    }
                    IndexShard percolatorShard = percolatorIndex.shard(0);
                    Engine.Searcher percolatorSearcher = percolatorShard.acquireSearcher("percolate");
                    try {
                        percolatorSearcher.searcher().search(request.query(), new QueryCollector(this.logger, this.queries, searcher, percolatorIndex, matches2));
                    }
                    catch (IOException e) {
                        this.logger.warn("failed to execute", e, new Object[0]);
                    }
                    finally {
                        percolatorSearcher.release();
                    }
                }
                finally {
                    this.indexCache.clear(searcher.getIndexReader());
                    this.fieldDataService.clear(searcher.getIndexReader());
                }
            }
            Response response = new Response(matches2, request.doc().mappingsModified());
            return response;
        }
        finally {
            this.memIndexPool.release(memoryIndex);
        }
    }

    private IndexService percolatorIndexServiceSafe() {
        IndexService indexService = this.indicesService.indexService("_percolator");
        if (indexService == null) {
            throw new PercolateIndexUnavailable(new Index("_percolator"));
        }
        return indexService;
    }

    public void clearQueries() {
        this.queries.clear();
    }

    static class QueryCollector
    extends Collector {
        private final IndexFieldData uidFieldData;
        private final IndexSearcher searcher;
        private final IndexService percolatorIndex;
        private final List<String> matches;
        private final Map<String, Query> queries;
        private final ESLogger logger;
        private final Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
        private BytesValues values;

        QueryCollector(ESLogger logger, Map<String, Query> queries, IndexSearcher searcher, IndexService percolatorIndex, List<String> matches2) {
            this.logger = logger;
            this.queries = queries;
            this.searcher = searcher;
            this.percolatorIndex = percolatorIndex;
            this.matches = matches2;
            this.uidFieldData = percolatorIndex.fieldData().getForField(new FieldMapper.Names(UidFieldMapper.NAME), new FieldDataType("string", ImmutableSettings.builder().put("format", "paged_bytes")));
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.values.setDocument(doc) == 0) {
                return;
            }
            String id = Uid.idFromUid(this.values.nextValue()).toUtf8();
            Query query = this.queries.get(id);
            if (query == null) {
                return;
            }
            try {
                this.collector.reset();
                this.searcher.search(query, this.collector);
                if (this.collector.exists()) {
                    this.matches.add(id);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + id + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = this.uidFieldData.load(context).getBytesValues(false);
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            PercolatorExecutor.this.memIndexPool.updateSettings(settings);
        }
    }

    static final class MemoryIndexPool {
        private volatile BlockingQueue<ReusableMemoryIndex> memoryIndexQueue;
        private int poolMaxSize;
        private int poolCurrentSize;
        private volatile long bytesPerMemoryIndex;
        private ByteSizeValue maxMemorySize;
        private volatile TimeValue timeout;

        public MemoryIndexPool(Settings settings) {
            this.poolMaxSize = settings.getAsInt(PercolatorExecutor.PERCOLATE_POOL_SIZE, (Integer)10);
            if (this.poolMaxSize <= 0) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.size size must be > 0 but was [" + this.poolMaxSize + "]");
            }
            this.memoryIndexQueue = new ArrayBlockingQueue<ReusableMemoryIndex>(this.poolMaxSize);
            this.maxMemorySize = settings.getAsBytesSize(PercolatorExecutor.PERCOLATE_POOL_MAX_MEMORY, new ByteSizeValue(1L, ByteSizeUnit.MB));
            if (this.maxMemorySize.bytes() < 0L) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.reuse_memory_size must be positive but was [" + this.maxMemorySize.bytes() + "]");
            }
            this.timeout = settings.getAsTime(PercolatorExecutor.PERCOLATE_TIMEOUT, new TimeValue(100L));
            if (this.timeout.millis() < 0L) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.timeout must be positive but was [" + this.timeout + "]");
            }
            this.bytesPerMemoryIndex = this.maxMemorySize.bytes() / (long)this.poolMaxSize;
        }

        public synchronized void updateSettings(Settings settings) {
            int newPoolSize = settings.getAsInt(PercolatorExecutor.PERCOLATE_POOL_SIZE, (Integer)this.poolMaxSize);
            if (newPoolSize <= 0) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.size size must be > 0 but was [" + newPoolSize + "]");
            }
            ByteSizeValue byteSize = settings.getAsBytesSize(PercolatorExecutor.PERCOLATE_POOL_MAX_MEMORY, this.maxMemorySize);
            if (byteSize.bytes() < 0L) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.reuse_memory_size must be positive but was [" + byteSize.bytes() + "]");
            }
            this.timeout = settings.getAsTime(PercolatorExecutor.PERCOLATE_TIMEOUT, this.timeout);
            if (this.timeout.millis() < 0L) {
                throw new ElasticSearchIllegalArgumentException("index.percolate.pool.timeout must be positive but was [" + this.timeout + "]");
            }
            if (this.maxMemorySize.equals(byteSize) && newPoolSize == this.poolMaxSize) {
                return;
            }
            this.maxMemorySize = byteSize;
            this.poolMaxSize = newPoolSize;
            this.poolCurrentSize = Integer.MAX_VALUE;
            this.bytesPerMemoryIndex = byteSize.bytes() / (long)newPoolSize;
            this.memoryIndexQueue = new ArrayBlockingQueue<ReusableMemoryIndex>(newPoolSize);
            this.poolCurrentSize = 0;
        }

        public ReusableMemoryIndex acquire() {
            BlockingQueue<ReusableMemoryIndex> queue = this.memoryIndexQueue;
            ReusableMemoryIndex poll = (ReusableMemoryIndex)queue.poll();
            return poll == null ? this.waitOrCreate(queue) : poll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReusableMemoryIndex waitOrCreate(BlockingQueue<ReusableMemoryIndex> queue) {
            MemoryIndexPool memoryIndexPool = this;
            synchronized (memoryIndexPool) {
                if (this.poolCurrentSize < this.poolMaxSize) {
                    ++this.poolCurrentSize;
                    return new ReusableMemoryIndex(false, this.bytesPerMemoryIndex);
                }
            }
            ReusableMemoryIndex poll = null;
            try {
                TimeValue timeout = this.timeout;
                poll = queue.poll(timeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return poll == null ? new ReusableMemoryIndex(false, this.bytesPerMemoryIndex) : poll;
        }

        public void release(ReusableMemoryIndex index) {
            assert (index != null) : "can't release null reference";
            if (this.bytesPerMemoryIndex == index.getMaxReuseBytes()) {
                index.reset();
                this.memoryIndexQueue.offer(index);
            }
        }
    }

    public static final class Response {
        private final List<String> matches;
        private final boolean mappersAdded;

        public Response(List<String> matches2, boolean mappersAdded) {
            this.matches = matches2;
            this.mappersAdded = mappersAdded;
        }

        public boolean mappersAdded() {
            return this.mappersAdded;
        }

        public List<String> matches() {
            return this.matches;
        }
    }

    public static class DocAndQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final Query query;

        public DocAndQueryRequest(ParsedDocument doc, @Nullable Query query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        Query query() {
            return this.query;
        }
    }

    public static class DocAndSourceQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final String query;

        public DocAndSourceQueryRequest(ParsedDocument doc, @Nullable String query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        String query() {
            return this.query;
        }
    }

    public static class SourceRequest {
        private final String type;
        private final BytesReference source;

        public SourceRequest(String type, BytesReference source) {
            this.type = type;
            this.source = source;
        }

        public String type() {
            return this.type;
        }

        public BytesReference source() {
            return this.source;
        }
    }
}

