/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.multifield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;

public class MultiFieldMapper
implements Mapper,
AllFieldMapper.IncludeInAll {
    public static final String CONTENT_TYPE = "multi_field";
    private final String name;
    private final ContentPath.Type pathType;
    private final Object mutex = new Object();
    private volatile ImmutableMap<String, Mapper> mappers = ImmutableMap.of();
    private volatile Mapper defaultMapper;

    public MultiFieldMapper(String name, ContentPath.Type pathType, Mapper defaultMapper) {
        this(name, pathType, new HashMap<String, Mapper>(), defaultMapper);
    }

    public MultiFieldMapper(String name, ContentPath.Type pathType, Map<String, Mapper> mappers, Mapper defaultMapper) {
        this.name = name;
        this.pathType = pathType;
        this.mappers = ImmutableMap.copyOf(mappers);
        this.defaultMapper = defaultMapper;
        for (Mapper mapper : mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            ((AllFieldMapper.IncludeInAll)mapper).includeInAll(false);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null && this.defaultMapper != null && this.defaultMapper instanceof AllFieldMapper.IncludeInAll) {
            ((AllFieldMapper.IncludeInAll)this.defaultMapper).includeInAll(includeInAll);
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.defaultMapper != null && this.defaultMapper instanceof AllFieldMapper.IncludeInAll) {
            ((AllFieldMapper.IncludeInAll)this.defaultMapper).includeInAllIfNotSet(includeInAll);
        }
    }

    public ContentPath.Type pathType() {
        return this.pathType;
    }

    public Mapper defaultMapper() {
        return this.defaultMapper;
    }

    public ImmutableMap<String, Mapper> mappers() {
        return this.mappers;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        if (this.defaultMapper != null) {
            this.defaultMapper.parse(context);
        }
        context.path().add(this.name);
        for (Mapper mapper : this.mappers.values()) {
            mapper.parse(context);
        }
        context.path().remove();
        context.path().pathType(origPathType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!(mergeWith instanceof MultiFieldMapper) && !(mergeWith instanceof AbstractFieldMapper)) {
            mergeContext.addConflict("Can't merge a non multi_field / non simple mapping [" + mergeWith.name() + "] with a multi_field mapping [" + this.name() + "]");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (mergeWith instanceof AbstractFieldMapper) {
                if (this.defaultMapper == null && !mergeContext.mergeFlags().simulate()) {
                    mergeContext.docMapper().addFieldMappers((FieldMapper)this.defaultMapper);
                    this.defaultMapper = mergeWith;
                }
            } else {
                MultiFieldMapper mergeWithMultiField = (MultiFieldMapper)mergeWith;
                ArrayList<FieldMapper<Object>> newFieldMappers = null;
                MapBuilder<String, Mapper> newMappersBuilder = null;
                Mapper newDefaultMapper = null;
                if (this.defaultMapper == null) {
                    if (mergeWithMultiField.defaultMapper != null && !mergeContext.mergeFlags().simulate()) {
                        if (newFieldMappers == null) {
                            newFieldMappers = new ArrayList<FieldMapper>();
                        }
                        newFieldMappers.add((FieldMapper)this.defaultMapper);
                        newDefaultMapper = mergeWithMultiField.defaultMapper;
                    }
                } else if (mergeWithMultiField.defaultMapper != null) {
                    this.defaultMapper.merge(mergeWithMultiField.defaultMapper, mergeContext);
                }
                for (Mapper mergeWithMapper : mergeWithMultiField.mappers.values()) {
                    Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.name());
                    if (mergeIntoMapper == null) {
                        if (mergeContext.mergeFlags().simulate()) continue;
                        if (mergeWithMapper instanceof AllFieldMapper.IncludeInAll) {
                            ((AllFieldMapper.IncludeInAll)mergeWithMapper).includeInAll(false);
                        }
                        if (newMappersBuilder == null) {
                            newMappersBuilder = MapBuilder.newMapBuilder(this.mappers);
                        }
                        newMappersBuilder.put(mergeWithMapper.name(), mergeWithMapper);
                        if (!(mergeWithMapper instanceof AbstractFieldMapper)) continue;
                        if (newFieldMappers == null) {
                            newFieldMappers = new ArrayList();
                        }
                        newFieldMappers.add((FieldMapper)mergeWithMapper);
                        continue;
                    }
                    mergeIntoMapper.merge(mergeWithMapper, mergeContext);
                }
                if (newFieldMappers != null && !newFieldMappers.isEmpty()) {
                    mergeContext.docMapper().addFieldMappers(newFieldMappers);
                }
                if (newDefaultMapper != null) {
                    this.defaultMapper = newDefaultMapper;
                }
                if (newMappersBuilder != null) {
                    this.mappers = newMappersBuilder.immutableMap();
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.defaultMapper != null) {
            this.defaultMapper.close();
        }
        for (Mapper mapper : this.mappers.values()) {
            mapper.close();
        }
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        if (this.defaultMapper != null) {
            this.defaultMapper.traverse(fieldMapperListener);
        }
        for (Mapper mapper : this.mappers.values()) {
            mapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", CONTENT_TYPE);
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("fields");
        if (this.defaultMapper != null) {
            this.defaultMapper.toXContent(builder, params);
        }
        if (this.mappers.size() <= 1) {
            for (Mapper mapper : this.mappers.values()) {
                mapper.toXContent(builder, params);
            }
        } else {
            TreeMap<String, Mapper> sortedMappers = new TreeMap<String, Mapper>(this.mappers);
            for (Mapper mapper : sortedMappers.values()) {
                mapper.toXContent(builder, params);
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.multiField(name);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry2.getKey());
                Object fieldNode = entry2.getValue();
                if (fieldName.equals("path")) {
                    builder.pathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                for (Map.Entry entry1 : fieldsNode.entrySet()) {
                    String propName = (String)entry1.getKey();
                    Map propNode = (Map)entry1.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode == null) {
                        throw new MapperParsingException("No type specified for property [" + propName + "]");
                    }
                    String type = typeNode.toString();
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    builder.add(typeParser.parse(propName, propNode, parserContext));
                }
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, MultiFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private final List<Mapper.Builder> mappersBuilders = Lists.newArrayList();
        private Mapper.Builder defaultMapperBuilder;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder add(Mapper.Builder builder) {
            if (builder.name().equals(this.name)) {
                this.defaultMapperBuilder = builder;
            } else {
                this.mappersBuilders.add(builder);
            }
            return this;
        }

        @Override
        public MultiFieldMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            Mapper defaultMapper = null;
            if (this.defaultMapperBuilder != null) {
                defaultMapper = (Mapper)this.defaultMapperBuilder.build(context);
            }
            String origSourcePath = context.path().sourcePath(context.path().fullPathAsText(this.name));
            context.path().add(this.name);
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                mappers.put(mapper.name(), (Mapper)mapper);
            }
            context.path().remove();
            context.path().sourcePath(origSourcePath);
            context.path().pathType(origPathType);
            return new MultiFieldMapper(this.name, this.pathType, mappers, defaultMapper);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

