/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class TypeFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    public TypeFieldMapper() {
        this("_type", "_type");
    }

    protected TypeFieldMapper(String name, String indexName) {
        this(name, indexName, 1.0f, new FieldType(Defaults.FIELD_TYPE), null, null);
    }

    public TypeFieldMapper(String name, String indexName, float boost, FieldType fieldType, PostingsFormatProvider provider, @Nullable Settings fieldDataSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, provider, null, null, fieldDataSettings);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public String value(Object value2) {
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        return new XConstantScoreQuery(context.cacheFilter(this.termFilter(value2, context), null));
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        if (!this.fieldType.indexed()) {
            return new PrefixFilter(new Term(UidFieldMapper.NAME, Uid.typePrefixAsBytes(BytesRefs.toBytesRef(value2))));
        }
        return new TermFilter(this.names().createIndexNameTerm(BytesRefs.toBytesRef(value2)));
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.fieldType.indexed() && !this.fieldType.stored()) {
            return null;
        }
        return new Field(this.names.indexName(), context.type(), this.fieldType);
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType.stored() == Defaults.FIELD_TYPE.stored() && this.fieldType.indexed() == Defaults.FIELD_TYPE.indexed()) {
            return builder;
        }
        builder.startObject("_type");
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed()) {
            builder.field("index", TypeFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.type();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, TypeFieldMapper> {
        public Builder() {
            super("_type", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_type";
        }

        @Override
        public TypeFieldMapper build(Mapper.BuilderContext context) {
            return new TypeFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.provider, this.fieldDataSettings);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_type";
        public static final String INDEX_NAME = "_type";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }
}

