/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.RegexpFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class IdFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";
    private final String path;

    public IdFieldMapper() {
        this("_id", "_id", new FieldType(Defaults.FIELD_TYPE));
    }

    public IdFieldMapper(FieldType fieldType) {
        this("_id", "_id", fieldType);
    }

    protected IdFieldMapper(String name, String indexName, FieldType fieldType) {
        this(name, indexName, 1.0f, fieldType, Defaults.PATH, null, null);
    }

    protected IdFieldMapper(String name, String indexName, float boost, FieldType fieldType, String path, PostingsFormatProvider provider, @Nullable Settings fieldDataSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, provider, null, null, fieldDataSettings);
        this.path = path;
    }

    public String path() {
        return this.path;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public String value(Object value2) {
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termQuery(value2, context);
        }
        return new ConstantScoreQuery(this.termFilter(value2, context));
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termFilter(value2, context);
        }
        return new TermsFilter(UidFieldMapper.NAME, Uid.createTypeUids(context.queryTypes(), value2));
    }

    @Override
    public Filter termsFilter(List values2, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termsFilter(values2, context);
        }
        return new TermsFilter(UidFieldMapper.NAME, Uid.createTypeUids(context.queryTypes(), values2));
    }

    @Override
    public Query prefixQuery(Object value2, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.prefixQuery(value2, method, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            PrefixQuery prefixQuery = new PrefixQuery(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value2))));
            if (method != null) {
                prefixQuery.setRewriteMethod(method);
            }
            return prefixQuery;
        }
        BooleanQuery query = new BooleanQuery();
        for (String queryType : queryTypes) {
            PrefixQuery prefixQuery = new PrefixQuery(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value2))));
            if (method != null) {
                prefixQuery.setRewriteMethod(method);
            }
            query.add(prefixQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public Filter prefixFilter(Object value2, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.prefixFilter(value2, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            return new PrefixFilter(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value2))));
        }
        XBooleanFilter filter2 = new XBooleanFilter();
        for (String queryType : queryTypes) {
            filter2.add(new PrefixFilter(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value2)))), BooleanClause.Occur.SHOULD);
        }
        return filter2;
    }

    @Override
    public Query regexpQuery(Object value2, int flags, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.regexpQuery(value2, flags, method, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value2))), flags);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            return regexpQuery;
        }
        BooleanQuery query = new BooleanQuery();
        for (String queryType : queryTypes) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value2))), flags);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query.add(regexpQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public Filter regexpFilter(Object value2, int flags, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.regexpFilter(value2, flags, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            return new RegexpFilter(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value2))), flags);
        }
        XBooleanFilter filter2 = new XBooleanFilter();
        for (String queryType : queryTypes) {
            filter2.add(new RegexpFilter(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value2))), flags), BooleanClause.Occur.SHOULD);
        }
        return filter2;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentName() != null && parser.currentName().equals("_id") && parser.currentToken().isValue()) {
            String id = parser.text();
            if (context.id() != null && !context.id().equals(id)) {
                throw new MapperParsingException("Provided id [" + context.id() + "] does not match the content one [" + id + "]");
            }
            context.id(id);
            if (!this.fieldType.indexed() && !this.fieldType.stored()) {
                return null;
            }
            return new Field(this.names.indexName(), context.id(), this.fieldType);
        }
        if (!this.fieldType.indexed() && !this.fieldType.stored()) {
            return null;
        }
        return new Field(this.names.indexName(), context.id(), this.fieldType);
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType.stored() == Defaults.FIELD_TYPE.stored() && this.fieldType.indexed() == Defaults.FIELD_TYPE.indexed() && this.path == Defaults.PATH && this.customFieldDataSettings == null && (this.postingsFormat == null || this.postingsFormat.name().equals(this.defaultPostingFormat()))) {
            return builder;
        }
        builder.startObject("_id");
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed()) {
            builder.field("index", IdFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        if (includeDefaults || this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        if (this.postingsFormat != null) {
            if (includeDefaults || !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
                builder.field("postings_format", this.postingsFormat.name());
            }
        } else if (includeDefaults) {
            String format2 = this.defaultPostingFormat();
            if (format2 == null) {
                format2 = "default";
            }
            builder.field("postings_format", format2);
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.id();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry2.getKey());
                Object fieldNode = entry2.getValue();
                if (!fieldName.equals("path")) continue;
                builder.path(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, IdFieldMapper> {
        private String path = Defaults.PATH;

        public Builder() {
            super("_id", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_id";
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        @Override
        public IdFieldMapper build(Mapper.BuilderContext context) {
            return new IdFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.path, this.provider, this.fieldDataSettings);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_id";
        public static final String INDEX_NAME = "_id";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final String PATH;

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
            PATH = null;
        }
    }
}

