/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class BoostFieldMapper
extends NumberFieldMapper<Float>
implements InternalMapper,
RootMapper {
    public static final String CONTENT_TYPE = "_boost";
    public static final String NAME = "_boost";
    private final Float nullValue;

    public BoostFieldMapper() {
        this("_boost", "_boost");
    }

    protected BoostFieldMapper(String name, String indexName) {
        this(name, indexName, 4, 1.0f, new FieldType(Defaults.FIELD_TYPE), Defaults.NULL_VALUE, null, null);
    }

    protected BoostFieldMapper(String name, String indexName, int precisionStep, float boost, FieldType fieldType, Float nullValue, PostingsFormatProvider provider, @Nullable Settings fieldDataSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), precisionStep, boost, fieldType, Defaults.IGNORE_MALFORMED, NumericFloatAnalyzer.buildNamedAnalyzer(precisionStep), NumericFloatAnalyzer.buildNamedAnalyzer(Integer.MAX_VALUE), provider, null, null, fieldDataSettings);
        this.nullValue = nullValue;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("float");
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            return Float.valueOf(((Number)value2).floatValue());
        }
        if (value2 instanceof BytesRef) {
            return Float.valueOf(Numbers.bytesToFloat((BytesRef)value2));
        }
        return Float.valueOf(Float.parseFloat(value2.toString()));
    }

    @Override
    public BytesRef indexedValueForSearch(Object value2) {
        int intValue = NumericUtils.floatToSortableInt(this.parseValue(value2));
        BytesRef bytesRef = new BytesRef();
        NumericUtils.intToPrefixCoded(intValue, this.precisionStep(), bytesRef);
        return bytesRef;
    }

    private float parseValue(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).floatValue();
        }
        if (value2 instanceof BytesRef) {
            return Float.parseFloat(((BytesRef)value2).utf8ToString());
        }
        return Float.parseFloat(value2.toString());
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions, boolean transpositions) {
        float iValue = Float.parseFloat(value2);
        float iSim = Float.parseFloat(minSim);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(iValue - iSim), Float.valueOf(iValue + iSim), true, true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newFloatRange((IndexNumericFieldData)fieldData.getForField(this), lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, this.nullValue, this.nullValue, true, true);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        float value2 = this.parseFloatValue(context);
        if (!Float.isNaN(value2)) {
            context.docBoost(value2);
        }
        super.parse(context);
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException {
        float value2 = this.parseFloatValue(context);
        if (Float.isNaN(value2)) {
            return null;
        }
        context.docBoost(value2);
        return new FloatFieldMapper.CustomFloatNumericField((NumberFieldMapper)this, value2, this.fieldType);
    }

    private float parseFloatValue(ParseContext context) throws IOException {
        float value2;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return Float.NaN;
            }
            value2 = this.nullValue.floatValue();
        } else {
            value2 = context.parser().floatValue();
        }
        return value2;
    }

    @Override
    protected String contentType() {
        return "_boost";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.name().equals("_boost") && this.nullValue == null && this.fieldType.indexed() == Defaults.FIELD_TYPE.indexed() && this.fieldType.stored() == Defaults.FIELD_TYPE.stored() && this.customFieldDataSettings == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.name().equals("_boost")) {
            builder.field("name", this.name());
        }
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed()) {
            builder.field("index", this.fieldType.indexed());
        }
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            String name = node.get("name") == null ? "_boost" : node.get("name").toString();
            Builder builder = MapperBuilders.boost(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry2.getKey());
                Object propNode = entry2.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, BoostFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public BoostFieldMapper build(Mapper.BuilderContext context) {
            return new BoostFieldMapper(this.name, this.buildIndexName(context), this.precisionStep, this.boost, this.fieldType, this.nullValue, this.provider, this.fieldDataSettings);
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NAME = "_boost";
        public static final Float NULL_VALUE = null;
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(false);
        }
    }
}

