/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class GeoPointFieldMapper
extends AbstractFieldMapper<GeoPoint>
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    private final ContentPath.Type pathType;
    private final boolean enableLatLon;
    private final boolean enableGeoHash;
    private final boolean enableGeohashPrefix;
    private final Integer precisionStep;
    private final int geoHashPrecision;
    private final DoubleFieldMapper latMapper;
    private final DoubleFieldMapper lonMapper;
    private final StringFieldMapper geohashMapper;
    private final boolean validateLon;
    private final boolean validateLat;
    private final boolean normalizeLon;
    private final boolean normalizeLat;

    public GeoPointFieldMapper(FieldMapper.Names names, FieldType fieldType, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsFormat, SimilarityProvider similarity, @Nullable Settings fieldDataSettings, Settings indexSettings, ContentPath.Type pathType, boolean enableLatLon, boolean enableGeoHash, boolean enableGeohashPrefix, Integer precisionStep, int geoHashPrecision, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geohashMapper, boolean validateLon, boolean validateLat, boolean normalizeLon, boolean normalizeLat) {
        super(names, 1.0f, fieldType, null, indexAnalyzer, postingsFormat, similarity, null, fieldDataSettings);
        this.pathType = pathType;
        this.enableLatLon = enableLatLon;
        this.enableGeoHash = enableGeoHash || enableGeohashPrefix;
        this.enableGeohashPrefix = enableGeohashPrefix;
        this.precisionStep = precisionStep;
        this.geoHashPrecision = geoHashPrecision;
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geohashMapper = geohashMapper;
        this.validateLat = validateLat;
        this.validateLon = validateLon;
        this.normalizeLat = normalizeLat;
        this.normalizeLon = normalizeLon;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType(CONTENT_TYPE);
    }

    public DoubleFieldMapper latMapper() {
        return this.latMapper;
    }

    public DoubleFieldMapper lonMapper() {
        return this.lonMapper;
    }

    public StringFieldMapper geoHashStringMapper() {
        return this.geohashMapper;
    }

    public boolean isEnableLatLon() {
        return this.enableLatLon;
    }

    @Override
    public GeoPoint value(Object value2) {
        if (value2 instanceof GeoPoint) {
            return (GeoPoint)value2;
        }
        return GeoPoint.parseFromLatLon(value2.toString());
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        context.path().add(this.name());
        XContentParser.Token token2 = context.parser().currentToken();
        if (token2 == XContentParser.Token.START_ARRAY) {
            token2 = context.parser().nextToken();
            if (token2 == XContentParser.Token.START_ARRAY) {
                while (token2 != XContentParser.Token.END_ARRAY) {
                    token2 = context.parser().nextToken();
                    double lon = context.parser().doubleValue();
                    token2 = context.parser().nextToken();
                    double lat = context.parser().doubleValue();
                    while ((token2 = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parseLatLon(context, lat, lon);
                    token2 = context.parser().nextToken();
                }
            } else if (token2 == XContentParser.Token.VALUE_NUMBER) {
                double lon = context.parser().doubleValue();
                token2 = context.parser().nextToken();
                double lat = context.parser().doubleValue();
                while ((token2 = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                this.parseLatLon(context, lat, lon);
            } else {
                while (token2 != XContentParser.Token.END_ARRAY) {
                    if (token2 == XContentParser.Token.START_OBJECT) {
                        this.parseObjectLatLon(context);
                    } else if (token2 == XContentParser.Token.VALUE_STRING) {
                        this.parseStringLatLon(context);
                    }
                    token2 = context.parser().nextToken();
                }
            }
        } else if (token2 == XContentParser.Token.START_OBJECT) {
            this.parseObjectLatLon(context);
        } else if (token2 == XContentParser.Token.VALUE_STRING) {
            this.parseStringLatLon(context);
        }
        context.path().remove();
        context.path().pathType(origPathType);
    }

    private void parseStringLatLon(ParseContext context) throws IOException {
        String value2 = context.parser().text();
        int comma = value2.indexOf(44);
        if (comma != -1) {
            double lat = Double.parseDouble(value2.substring(0, comma).trim());
            double lon = Double.parseDouble(value2.substring(comma + 1).trim());
            this.parseLatLon(context, lat, lon);
        } else {
            this.parseGeohash(context, value2);
        }
    }

    private void parseObjectLatLon(ParseContext context) throws IOException {
        XContentParser.Token token2;
        String currentName = context.parser().currentName();
        Double lat = null;
        Double lon = null;
        String geohash = null;
        while ((token2 = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentName = context.parser().currentName();
                continue;
            }
            if (!token2.isValue()) continue;
            if (currentName.equals("lat")) {
                lat = context.parser().doubleValue();
                continue;
            }
            if (currentName.equals("lon")) {
                lon = context.parser().doubleValue();
                continue;
            }
            if (!currentName.equals("geohash")) continue;
            geohash = context.parser().text();
        }
        if (geohash != null) {
            this.parseGeohash(context, geohash);
        } else if (lat != null && lon != null) {
            this.parseLatLon(context, lat, lon);
        }
    }

    private void parseGeohashField(ParseContext context, String geohash) throws IOException {
        int len = Math.min(this.geoHashPrecision, geohash.length());
        int min2 = this.enableGeohashPrefix ? 1 : geohash.length();
        for (int i = len; i >= min2; --i) {
            context.externalValue(geohash.substring(0, i));
            this.geohashMapper.parse(context);
        }
    }

    private void parseLatLon(ParseContext context, double lat, double lon) throws IOException {
        if (this.normalizeLat || this.normalizeLon) {
            GeoPoint point = new GeoPoint(lat, lon);
            GeoUtils.normalizePoint(point, this.normalizeLat, this.normalizeLon);
            lat = point.lat();
            lon = point.lon();
        }
        if (this.validateLat && (lat > 90.0 || lat < -90.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal latitude value [" + lat + "] for " + this.name());
        }
        if (this.validateLon && (lon > 180.0 || lon < -180.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal longitude value [" + lon + "] for " + this.name());
        }
        if (this.fieldType.indexed() || this.fieldType.stored()) {
            Field field2 = new Field(this.names.indexName(), Double.toString(lat) + ',' + Double.toString(lon), this.fieldType);
            context.doc().add(field2);
        }
        if (this.enableGeoHash) {
            this.parseGeohashField(context, GeoHashUtils.encode(lat, lon, this.geoHashPrecision));
        }
        if (this.enableLatLon) {
            context.externalValue(lat);
            this.latMapper.parse(context);
            context.externalValue(lon);
            this.lonMapper.parse(context);
        }
    }

    private void parseGeohash(ParseContext context, String geohash) throws IOException {
        GeoPoint point = GeoHashUtils.decode(geohash);
        if (this.normalizeLat || this.normalizeLon) {
            GeoUtils.normalizePoint(point, this.normalizeLat, this.normalizeLon);
        }
        if (this.validateLat && (point.lat() > 90.0 || point.lat() < -90.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
        }
        if (this.validateLon && (point.lon() > 180.0 || point.lon() < -180.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
        }
        if (this.fieldType.indexed() || this.fieldType.stored()) {
            Field field2 = new Field(this.names.indexName(), Double.toString(point.lat()) + ',' + Double.toString(point.lon()), this.fieldType);
            context.doc().add(field2);
        }
        if (this.enableGeoHash) {
            this.parseGeohashField(context, geohash);
        }
        if (this.enableLatLon) {
            context.externalValue(point.lat());
            this.latMapper.parse(context);
            context.externalValue(point.lon());
            this.lonMapper.parse(context);
        }
    }

    @Override
    public void close() {
        if (this.latMapper != null) {
            this.latMapper.close();
        }
        if (this.lonMapper != null) {
            this.lonMapper.close();
        }
        if (this.geohashMapper != null) {
            this.geohashMapper.close();
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        super.traverse(fieldMapperListener);
        if (this.enableGeoHash) {
            this.geohashMapper.traverse(fieldMapperListener);
        }
        if (this.enableLatLon) {
            this.latMapper.traverse(fieldMapperListener);
            this.lonMapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        if (includeDefaults || this.enableLatLon) {
            builder.field("lat_lon", this.enableLatLon);
        }
        if (includeDefaults || this.enableGeoHash) {
            builder.field("geohash", this.enableGeoHash);
        }
        if (includeDefaults || this.enableGeohashPrefix) {
            builder.field("geohash_prefix", this.enableGeohashPrefix);
        }
        if (includeDefaults || this.geoHashPrecision != 12) {
            builder.field("geohash_precision", this.geoHashPrecision);
        }
        if (includeDefaults || this.precisionStep != null) {
            builder.field("precision_step", this.precisionStep);
        }
        if (includeDefaults || !this.validateLat || !this.validateLon) {
            if (this.validateLat && this.validateLon) {
                builder.field("validate", true);
            } else if (!this.validateLat && !this.validateLon) {
                builder.field("validate", false);
            } else {
                if (includeDefaults || !this.validateLat) {
                    builder.field("validate_lat", this.validateLat);
                }
                if (includeDefaults || !this.validateLon) {
                    builder.field("validate_lon", this.validateLon);
                }
            }
        }
        if (includeDefaults || !this.normalizeLat || !this.normalizeLon) {
            if (this.normalizeLat && this.normalizeLon) {
                builder.field("normalize", true);
            } else if (!this.normalizeLat && !this.normalizeLon) {
                builder.field("normalize", false);
            } else {
                if (includeDefaults || !this.normalizeLat) {
                    builder.field("normalize_lat", this.normalizeLat);
                }
                if (includeDefaults || !this.normalizeLon) {
                    builder.field("normalize_lon", this.normalizeLat);
                }
            }
        }
    }

    public static final class Encoding {
        private static final int MAX_NUM_BYTES = 14;
        private static final Encoding[] INSTANCES = new Encoding[15];
        private final DistanceUnit.Distance precision;
        private final int numBytes;
        private final int numBytesPerCoordinate;
        private final double factor;

        public static final Encoding of(int numBytesPerValue) {
            Encoding instance = INSTANCES[numBytesPerValue];
            if (instance == null) {
                throw new ElasticSearchIllegalStateException("No encoding for " + numBytesPerValue + " bytes per value");
            }
            return instance;
        }

        public static final Encoding of(DistanceUnit.Distance precision) {
            for (Encoding encoding : INSTANCES) {
                if (encoding == null || encoding.precision().compareTo(precision) > 0) continue;
                return encoding;
            }
            return INSTANCES[14];
        }

        private Encoding(int numBytes) {
            assert (numBytes >= 1 && numBytes <= 14);
            assert ((numBytes & 1) == 0);
            this.numBytes = numBytes;
            this.numBytesPerCoordinate = numBytes / 2;
            this.factor = Math.pow(2.0, -this.numBytesPerCoordinate * 8 + 9);
            assert ((double)(1L << this.numBytesPerCoordinate * 8 - 1) * this.factor > 180.0 && (double)(1L << this.numBytesPerCoordinate * 8 - 2) * this.factor < 180.0) : this.numBytesPerCoordinate + " " + this.factor;
            this.precision = numBytes == 14 ? new DistanceUnit.Distance(0.0, DistanceUnit.METERS) : new DistanceUnit.Distance(GeoDistance.PLANE.calculate(0.0, 0.0, this.factor / 2.0, this.factor / 2.0, DistanceUnit.METERS), DistanceUnit.METERS);
        }

        public DistanceUnit.Distance precision() {
            return this.precision;
        }

        public final int numBytes() {
            return this.numBytes;
        }

        public int numBitsPerCoordinate() {
            return this.numBytesPerCoordinate << 3;
        }

        public long encodeCoordinate(double lat) {
            return Math.round((lat + 180.0) / this.factor);
        }

        public double decodeCoordinate(long bits2) {
            return (double)bits2 * this.factor - 180.0;
        }

        private void encodeBits(long bits2, byte[] out, int offset) {
            for (int i = 0; i < this.numBytesPerCoordinate; ++i) {
                out[offset++] = (byte)bits2;
                bits2 >>>= 8;
            }
            assert (bits2 == 0L);
        }

        private long decodeBits(byte[] in, int offset) {
            long r = (long)in[offset++] & 0xFFL;
            for (int i = 1; i < this.numBytesPerCoordinate; ++i) {
                r = ((long)in[offset++] & 0xFFL) << i * 8;
            }
            return r;
        }

        public void encode(double lat, double lon, byte[] out, int offset) {
            this.encodeBits(this.encodeCoordinate(lat), out, offset);
            this.encodeBits(this.encodeCoordinate(lon), out, offset + this.numBytesPerCoordinate);
        }

        public GeoPoint decode(byte[] in, int offset, GeoPoint out) {
            long latBits = this.decodeBits(in, offset);
            long lonBits = this.decodeBits(in, offset + this.numBytesPerCoordinate);
            return this.decode(latBits, lonBits, out);
        }

        public GeoPoint decode(long latBits, long lonBits, GeoPoint out) {
            double lat = this.decodeCoordinate(latBits);
            double lon = this.decodeCoordinate(lonBits);
            return out.reset(lat, lon);
        }

        static {
            for (int numBytes = 2; numBytes <= 14; numBytes += 2) {
                Encoding.INSTANCES[numBytes] = new Encoding(numBytes);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.geoPointField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry2.getKey());
                Object fieldNode = entry2.getValue();
                if (fieldName.equals("path")) {
                    builder.pathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("lat_lon")) {
                    builder.enableLatLon(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash")) {
                    builder.enableGeoHash(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash_prefix")) {
                    builder.geohashPrefix(XContentMapValues.nodeBooleanValue(fieldNode));
                    if (!XContentMapValues.nodeBooleanValue(fieldNode)) continue;
                    builder.enableGeoHash(true);
                    continue;
                }
                if (fieldName.equals("precision_step")) {
                    builder.precisionStep(XContentMapValues.nodeIntegerValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash_precision")) {
                    builder.geoHashPrecision(XContentMapValues.nodeIntegerValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("validate")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lon")) {
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lat")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize_lat")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (!fieldName.equals("normalize_lon")) continue;
                builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, GeoPointFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private boolean enableGeoHash = false;
        private boolean enableGeohashPrefix = false;
        private boolean enableLatLon = false;
        private Integer precisionStep;
        private int geoHashPrecision = 12;
        boolean validateLat = true;
        boolean validateLon = true;
        boolean normalizeLat = true;
        boolean normalizeLon = true;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return this;
        }

        public Builder geohashPrefix(boolean enableGeohashPrefix) {
            this.enableGeohashPrefix = enableGeohashPrefix;
            return this;
        }

        public Builder enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return this;
        }

        @Override
        public Builder fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (Builder)this.builder;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            DoubleFieldMapper latMapper = null;
            DoubleFieldMapper lonMapper = null;
            context.path().add(this.name);
            if (this.enableLatLon) {
                AbstractFieldMapper.Builder latMapperBuilder = MapperBuilders.doubleField("lat").includeInAll(false);
                AbstractFieldMapper.Builder lonMapperBuilder = MapperBuilders.doubleField("lon").includeInAll(false);
                if (this.precisionStep != null) {
                    ((NumberFieldMapper.Builder)latMapperBuilder).precisionStep(this.precisionStep);
                    ((NumberFieldMapper.Builder)lonMapperBuilder).precisionStep(this.precisionStep);
                }
                latMapper = (DoubleFieldMapper)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)latMapperBuilder).includeInAll(false)).store(this.fieldType.stored()).build(context);
                lonMapper = (DoubleFieldMapper)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)lonMapperBuilder).includeInAll(false)).store(this.fieldType.stored()).build(context);
            }
            StringFieldMapper geohashMapper = null;
            if (this.enableGeoHash) {
                geohashMapper = ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)MapperBuilders.stringField("geohash").index(true)).tokenized(false)).includeInAll(false).omitNorms(true)).indexOptions(FieldInfo.IndexOptions.DOCS_ONLY)).build(context);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            this.fieldType.setTokenized(false);
            return new GeoPointFieldMapper(this.buildNames(context), this.fieldType, this.indexAnalyzer, this.searchAnalyzer, this.provider, this.similarity, this.fieldDataSettings, context.indexSettings(), origPathType, this.enableLatLon, this.enableGeoHash, this.enableGeohashPrefix, this.precisionStep, this.geoHashPrecision, latMapper, lonMapper, geohashMapper, this.validateLon, this.validateLat, this.normalizeLon, this.normalizeLat);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final boolean STORE = false;
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final boolean NORMALIZE_LAT = true;
        public static final boolean NORMALIZE_LON = true;
        public static final boolean VALIDATE_LAT = true;
        public static final boolean VALIDATE_LON = true;
        public static final FieldType FIELD_TYPE = new FieldType(StringFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String GEOHASH_SUFFIX = ".geohash";
    }
}

