/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;

public class TypeParsers {
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";

    public static void parseNumberField(NumberFieldMapper.Builder builder, String name, Map<String, Object> numberNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, numberNode, parserContext);
        for (Map.Entry<String, Object> entry2 : numberNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry2.getKey());
            Object propNode = entry2.getValue();
            if (propName.equals("precision_step")) {
                builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                continue;
            }
            if (propName.equals("ignore_malformed")) {
                builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (!propName.equals("similarity")) continue;
            builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
        }
    }

    public static void parseField(AbstractFieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        for (Map.Entry<String, Object> entry2 : fieldNode.entrySet()) {
            NamedAnalyzer analyzer;
            String propName = Strings.toUnderscoreCase(entry2.getKey());
            Object propNode = entry2.getValue();
            if (propName.equals("index_name")) {
                builder.indexName(propNode.toString());
                continue;
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.parseStore(name, propNode.toString()));
                continue;
            }
            if (propName.equals("index")) {
                TypeParsers.parseIndex(name, propNode.toString(), builder);
                continue;
            }
            if (propName.equals("tokenized")) {
                builder.tokenized(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("norms")) {
                Map<String, Object> properties = XContentMapValues.nodeMapValue(propNode, "norms");
                for (Map.Entry<String, Object> entry22 : properties.entrySet()) {
                    String propName2 = Strings.toUnderscoreCase(entry22.getKey());
                    Object propNode2 = entry22.getValue();
                    if (propName2.equals("enabled")) {
                        builder.omitNorms(!XContentMapValues.nodeBooleanValue(propNode2));
                        continue;
                    }
                    if (!propName2.equals("loading")) continue;
                    builder.normsLoading(FieldMapper.Loading.parse(XContentMapValues.nodeStringValue(propNode2, null), null));
                }
                continue;
            }
            if (propName.equals("omit_term_freq_and_positions")) {
                builder.indexOptions(XContentMapValues.nodeBooleanValue(propNode) ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("index_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("include_in_all")) {
                builder.includeInAll(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("postings_format")) {
                String postingFormatName = propNode.toString();
                builder.postingsFormat(parserContext.postingFormatService().get(postingFormatName));
                continue;
            }
            if (propName.equals("similarity")) {
                builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
                continue;
            }
            if (!propName.equals("fielddata")) continue;
            Settings settings = ImmutableSettings.builder().put(SettingsLoader.Helper.loadNestedFromMap(XContentMapValues.nodeMapValue(propNode, "fielddata"))).build();
            builder.fieldDataSettings(settings);
        }
    }

    private static FieldInfo.IndexOptions nodeIndexOptionValue(Object propNode) {
        String value2 = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_ONLY;
        }
        throw new ElasticSearchParseException("Failed to parse index option [" + value2 + "]");
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(String fieldName, Object node) {
        return Joda.forPattern(node.toString());
    }

    public static void parseTermVector(String fieldName, String termVector, AbstractFieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector = Strings.toUnderscoreCase(termVector))) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("Wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static void parseIndex(String fieldName, String index, AbstractFieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(index = Strings.toUnderscoreCase(index))) {
            builder.index(false);
        } else if ("not_analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(false);
        } else if ("analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(true);
        } else {
            throw new MapperParsingException("Wrong value for index [" + index + "] for field [" + fieldName + "]");
        }
    }

    public static boolean parseStore(String fieldName, String store) throws MapperParsingException {
        if ("no".equals(store)) {
            return false;
        }
        if ("yes".equals(store)) {
            return true;
        }
        return XContentMapValues.nodeBooleanValue(store);
    }

    public static ContentPath.Type parsePathType(String name, String path) throws MapperParsingException {
        if ("just_name".equals(path = Strings.toUnderscoreCase(path))) {
            return ContentPath.Type.JUST_NAME;
        }
        if ("full".equals(path)) {
            return ContentPath.Type.FULL;
        }
        throw new MapperParsingException("Wrong value for pathType [" + path + "] for object [" + name + "]");
    }
}

