/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.DoubleOpenHashSet;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.FieldDataTermsFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class NumberFieldMapper<T extends Number>
extends AbstractFieldMapper<T>
implements AllFieldMapper.IncludeInAll {
    protected int precisionStep;
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(NumberFieldMapper.this.precisionStep);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStream4 = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(4);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStream8 = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(8);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStreamMax = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(Integer.MAX_VALUE);
        }
    };

    protected NumberFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Explicit<Boolean> ignoreMalformed, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider provider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings) {
        super(names, boost, fieldType, indexAnalyzer, searchAnalyzer, provider, similarity, normsLoading, fieldDataSettings);
        this.precisionStep = precisionStep <= 0 || precisionStep >= this.maxPrecisionStep() ? Integer.MAX_VALUE : precisionStep;
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    protected abstract int maxPrecisionStep();

    public int precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        RuntimeException e;
        try {
            return this.innerParseCreateField(context);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (this.ignoreMalformed.value().booleanValue()) {
            return null;
        }
        throw e;
    }

    protected abstract Field innerParseCreateField(ParseContext var1) throws IOException;

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        return this.rangeQuery(value2, value2, true, true, context);
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        return this.rangeFilter(value2, value2, true, true, context);
    }

    @Override
    public abstract Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Filter rangeFilter(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Query fuzzyQuery(String var1, String var2, int var3, int var4, boolean var5);

    public abstract Filter rangeFilter(IndexFieldDataService var1, Object var2, Object var3, boolean var4, boolean var5, @Nullable QueryParseContext var6);

    @Override
    public Filter termsFilter(IndexFieldDataService fieldDataService, List values2, @Nullable QueryParseContext context) {
        IndexNumericFieldData fieldData = (IndexNumericFieldData)fieldDataService.getForField(this);
        if (fieldData.getNumericType().isFloatingPoint()) {
            DoubleOpenHashSet terms = new DoubleOpenHashSet((int)((float)values2.size() * 1.75f));
            int len = values2.size();
            for (int i = 0; i < len; ++i) {
                terms.add(this.parseDoubleValue(values2.get(i)));
            }
            return FieldDataTermsFilter.newDoubles(fieldData, terms);
        }
        LongOpenHashSet terms = new LongOpenHashSet((int)((float)values2.size() * 1.75f));
        int len = values2.size();
        for (int i = 0; i < len; ++i) {
            terms.add(this.parseLongValue(values2.get(i)));
        }
        return FieldDataTermsFilter.newLongs(fieldData, terms);
    }

    public double parseDoubleValue(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof BytesRef) {
            return Double.parseDouble(((BytesRef)value2).utf8ToString());
        }
        return Double.parseDouble(value2.toString());
    }

    public long parseLongValue(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof BytesRef) {
            return Long.parseLong(((BytesRef)value2).utf8ToString());
        }
        return Long.parseLong(value2.toString());
    }

    @Override
    public Object valueForSearch(Object value2) {
        return this.value(value2);
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            NumberFieldMapper nfmMergeWith = (NumberFieldMapper)mergeWith;
            this.precisionStep = nfmMergeWith.precisionStep;
            this.includeInAll = nfmMergeWith.includeInAll;
            if (nfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
            }
        }
    }

    @Override
    public void close() {
    }

    protected NumericTokenStream popCachedStream() {
        if (this.precisionStep == 4) {
            return tokenStream4.get();
        }
        if (this.precisionStep == 8) {
            return tokenStream8.get();
        }
        if (this.precisionStep == Integer.MAX_VALUE) {
            return tokenStreamMax.get();
        }
        return this.tokenStream.get();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public static abstract class CustomNumericField
    extends Field {
        protected final NumberFieldMapper mapper;

        public CustomNumericField(NumberFieldMapper mapper, Number value2, FieldType fieldType) {
            super(mapper.names().indexName(), fieldType);
            this.mapper = mapper;
            if (value2 != null) {
                this.fieldsData = value2;
            }
        }

        @Override
        public String stringValue() {
            return null;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends AbstractFieldMapper.Builder<T, Y> {
        protected int precisionStep = 4;
        private Boolean ignoreMalformed;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        @Override
        public T store(boolean store) {
            return (T)((Builder)super.store(store));
        }

        @Override
        public T boost(float boost) {
            return (T)((Builder)super.boost(boost));
        }

        @Override
        public T indexName(String indexName) {
            return (T)((Builder)super.indexName(indexName));
        }

        @Override
        public T includeInAll(Boolean includeInAll) {
            return (T)((Builder)super.includeInAll(includeInAll));
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final int PRECISION_STEP = 4;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final Explicit<Boolean> IGNORE_MALFORMED;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.freeze();
            IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        }
    }
}

