/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    protected FormatDateTimeFormatter dateTimeFormatter;
    private final boolean roundCeil;
    private final DateMathParser dateMathParser;
    private String nullValue;
    protected final TimeUnit timeUnit;

    public static Locale parseLocale(String locale) {
        String[] parts = locale.split("_", -1);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new ElasticSearchIllegalArgumentException("Can't parse locale: [" + locale + "]");
    }

    protected DateFieldMapper(FieldMapper.Names names, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, float boost, FieldType fieldType, String nullValue, TimeUnit timeUnit, boolean roundCeil, Explicit<Boolean> ignoreMalformed, PostingsFormatProvider provider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings) {
        super(names, precisionStep, boost, fieldType, ignoreMalformed, new NamedAnalyzer("_date/" + precisionStep, new NumericDateAnalyzer(precisionStep, dateTimeFormatter.parser())), new NamedAnalyzer("_date/max", new NumericDateAnalyzer(Integer.MAX_VALUE, dateTimeFormatter.parser())), provider, similarity, normsLoading, fieldDataSettings);
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
        this.timeUnit = timeUnit;
        this.roundCeil = roundCeil;
        this.dateMathParser = new DateMathParser(dateTimeFormatter, timeUnit);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("long");
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof BytesRef) {
            return Numbers.bytesToLong((BytesRef)value2);
        }
        return this.parseStringValue(value2.toString());
    }

    @Override
    public Object valueForSearch(Object value2) {
        if (value2 instanceof String) {
            return value2;
        }
        Long val = this.value(value2);
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(val);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value2) {
        BytesRef bytesRef = new BytesRef();
        NumericUtils.longToPrefixCoded(this.parseValue(value2), 0, bytesRef);
        return bytesRef;
    }

    private long parseValue(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof BytesRef) {
            return this.dateTimeFormatter.parser().parseMillis(((BytesRef)value2).utf8ToString());
        }
        return this.dateTimeFormatter.parser().parseMillis(value2.toString());
    }

    private String convertToString(Object value2) {
        if (value2 instanceof BytesRef) {
            return ((BytesRef)value2).utf8ToString();
        }
        return value2.toString();
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions, boolean transpositions) {
        long iSim;
        long iValue = this.dateMathParser.parse(value2, System.currentTimeMillis());
        try {
            iSim = TimeValue.parseTimeValue(minSim, null).millis();
        }
        catch (Exception e) {
            iSim = (long)Double.parseDouble(minSim);
        }
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value2, context);
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lValue, lValue, true, true);
    }

    public long parseToMilliseconds(Object value2, @Nullable QueryParseContext context) {
        return this.parseToMilliseconds(value2, context, false);
    }

    public long parseToMilliseconds(Object value2, @Nullable QueryParseContext context, boolean includeUpper) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return includeUpper && this.roundCeil ? this.dateMathParser.parseRoundCeil(this.convertToString(value2), now) : this.dateMathParser.parse(this.convertToString(value2), now);
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value2, context);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lValue, lValue, true, true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, context)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, context, includeUpper)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, context)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, context, includeUpper)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newLongRange((IndexNumericFieldData)fieldData.getForField(this), lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, context)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, context, includeUpper)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value2 = this.parseStringValue(this.nullValue);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, value2, value2, true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException {
        LongFieldMapper.CustomLongNumericField field2;
        String dateAsString = null;
        Long value2 = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value2 = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token2 = parser.currentToken();
            if (token2 == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token2 == XContentParser.Token.VALUE_NUMBER) {
                value2 = parser.longValue();
            } else if (token2 == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token2 == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token2 == XContentParser.Token.VALUE_NUMBER) {
                            value2 = parser.longValue();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (value2 != null) {
            field2 = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, this.timeUnit.toMillis(value2), this.fieldType);
            field2.setBoost(boost);
            return field2;
        }
        if (dateAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), dateAsString, boost);
        }
        value2 = this.parseStringValue(dateAsString);
        field2 = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value2, this.fieldType);
        field2.setBoost(boost);
        return field2;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
            this.dateTimeFormatter = ((DateFieldMapper)mergeWith).dateTimeFormatter;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.timeUnit != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.timeUnit.name().toLowerCase(Locale.ROOT));
        }
        if (this.dateTimeFormatter.locale() != null && this.dateTimeFormatter.locale() != Locale.ROOT) {
            builder.field("locale", (Object)this.dateTimeFormatter.locale());
        } else if (includeDefaults) {
            if (this.dateTimeFormatter.locale() == null) {
                builder.field("locale", (Object)Locale.ROOT);
            } else {
                builder.field("locale", (Object)this.dateTimeFormatter.locale());
            }
        }
    }

    private long parseStringValue(String value2) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value2);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number with locale [" + this.dateTimeFormatter.locale() + "]", e);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry2.getKey());
                Object propNode = entry2.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propName, propNode));
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(DateFieldMapper.parseLocale(propNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        private Locale locale;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            boolean roundCeil = true;
            if (context.indexSettings() != null) {
                Settings settings = context.indexSettings();
                roundCeil = settings.getAsBoolean("index.mapping.date.round_ceil", settings.getAsBoolean("index.mapping.date.parse_upper_inclusive", (Boolean)true));
            }
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            if (!this.locale.equals(this.dateTimeFormatter.locale())) {
                this.dateTimeFormatter = new FormatDateTimeFormatter(this.dateTimeFormatter.format(), this.dateTimeFormatter.parser(), this.dateTimeFormatter.printer(), this.locale);
            }
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.precisionStep, this.boost, this.fieldType, this.nullValue, this.timeUnit, roundCeil, this.ignoreMalformed(context), this.provider, this.similarity, this.normsLoading, this.fieldDataSettings);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime", Locale.ROOT);
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final String NULL_VALUE;
        public static final TimeUnit TIME_UNIT;
        public static final boolean ROUND_CEIL = true;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
            TIME_UNIT = TimeUnit.MILLISECONDS;
        }
    }
}

