/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.suggest.completion.AnalyzingCompletionLookupProvider;
import org.elasticsearch.search.suggest.completion.CompletionPostingsFormatProvider;
import org.elasticsearch.search.suggest.completion.CompletionTokenStream;

public class CompletionFieldMapper
extends AbstractFieldMapper<String> {
    public static final String CONTENT_TYPE = "completion";
    public static Set<String> ALLOWED_CONTENT_FIELD_NAMES = Sets.newHashSet("input", "output", "payload", "weight");
    private static final BytesRef EMPTY = new BytesRef();
    private final CompletionPostingsFormatProvider completionPostingsFormatProvider;
    private final AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider;
    private final boolean payloads;
    private final boolean preservePositionIncrements;
    private final boolean preserveSeparators;
    private int maxInputLength;

    public CompletionFieldMapper(FieldMapper.Names names, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider provider, SimilarityProvider similarity, boolean payloads, boolean preserveSeparators, boolean preservePositionIncrements, int maxInputLength) {
        super(names, 1.0f, Defaults.FIELD_TYPE, indexAnalyzer, searchAnalyzer, provider, similarity, null, null);
        this.analyzingSuggestLookupProvider = new AnalyzingCompletionLookupProvider(preserveSeparators, false, preservePositionIncrements, payloads);
        this.completionPostingsFormatProvider = new CompletionPostingsFormatProvider(CONTENT_TYPE, provider, this.analyzingSuggestLookupProvider);
        this.preserveSeparators = preserveSeparators;
        this.payloads = payloads;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxInputLength = maxInputLength;
    }

    @Override
    public PostingsFormatProvider postingsFormatProvider() {
        return this.completionPostingsFormatProvider;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token2 = parser.currentToken();
        String surfaceForm = null;
        BytesRef payload = null;
        long weight = -1L;
        ArrayList<String> inputs = Lists.newArrayListWithExpectedSize(4);
        if (token2 == XContentParser.Token.VALUE_STRING) {
            inputs.add(parser.text());
        } else {
            String currentFieldName = null;
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new ElasticSearchIllegalArgumentException("Unknown field name[" + currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if ("payload".equals(currentFieldName)) {
                    if (!this.isStoringPayloads()) {
                        throw new MapperException("Payloads disabled in mapping");
                    }
                    if (token2 == XContentParser.Token.START_OBJECT) {
                        XContentBuilder payloadBuilder = XContentFactory.contentBuilder(parser.contentType()).copyCurrentStructure(parser);
                        payload = payloadBuilder.bytes().toBytesRef();
                        payloadBuilder.close();
                        continue;
                    }
                    if (token2.isValue()) {
                        payload = parser.bytesOrNull();
                        continue;
                    }
                    throw new MapperException("payload doesn't support type " + (Object)((Object)token2));
                }
                if (token2 == XContentParser.Token.VALUE_STRING) {
                    if ("output".equals(currentFieldName)) {
                        surfaceForm = parser.text();
                    }
                    if (!"input".equals(currentFieldName)) continue;
                    inputs.add(parser.text());
                    continue;
                }
                if (token2 == XContentParser.Token.VALUE_NUMBER) {
                    if (!"weight".equals(currentFieldName)) continue;
                    XContentParser.NumberType numberType = parser.numberType();
                    if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                        throw new ElasticSearchIllegalArgumentException("Weight must be an integer, but was [" + parser.numberValue() + "]");
                    }
                    weight = parser.longValue();
                    if (weight >= 0L && weight <= Integer.MAX_VALUE) continue;
                    throw new ElasticSearchIllegalArgumentException("Weight must be in the interval [0..2147483647], but was [" + weight + "]");
                }
                if (token2 != XContentParser.Token.START_ARRAY || !"input".equals(currentFieldName)) continue;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    inputs.add(parser.text());
                }
            }
        }
        BytesRef bytesRef = payload = payload == null ? EMPTY : payload;
        if (surfaceForm == null) {
            for (String input2 : inputs) {
                BytesRef suggestPayload = this.analyzingSuggestLookupProvider.buildPayload(new BytesRef(input2), weight, payload);
                context.doc().add(this.getCompletionField(input2, suggestPayload));
            }
        } else {
            BytesRef suggestPayload = this.analyzingSuggestLookupProvider.buildPayload(new BytesRef(surfaceForm), weight, payload);
            for (String input3 : inputs) {
                context.doc().add(this.getCompletionField(input3, suggestPayload));
            }
        }
    }

    public Field getCompletionField(String input2, BytesRef payload) {
        String originalInput = input2;
        if (input2.length() > this.maxInputLength) {
            int len = CompletionFieldMapper.correctSubStringLen(input2, Math.min(this.maxInputLength, input2.length()));
            input2 = input2.substring(0, len);
        }
        for (int i = 0; i < input2.length(); ++i) {
            if (!CompletionFieldMapper.isReservedChar(input2.charAt(i))) continue;
            throw new ElasticSearchIllegalArgumentException("Illegal input [" + originalInput + "] UTF-16 codepoint  [0x" + Integer.toHexString(input2.charAt(i)).toUpperCase(Locale.ROOT) + "] at position " + i + " is a reserved character");
        }
        return new SuggestField(this.names.indexName(), input2, this.fieldType, payload, (CompletionTokenStream.ToFiniteStrings)this.analyzingSuggestLookupProvider);
    }

    public static int correctSubStringLen(String input2, int len) {
        if (Character.isHighSurrogate(input2.charAt(len - 1))) {
            assert (input2.length() >= len + 1 && Character.isLowSurrogate(input2.charAt(len)));
            return len + 1;
        }
        return len;
    }

    public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
        return this.analyzingSuggestLookupProvider.buildPayload(surfaceForm, weight, payload);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name()).field("type", CONTENT_TYPE);
        if (this.indexAnalyzer.name().equals(this.searchAnalyzer.name())) {
            builder.field("analyzer", this.indexAnalyzer.name());
        } else {
            builder.field("index_analyzer", this.indexAnalyzer.name()).field("search_analyzer", this.searchAnalyzer.name());
        }
        builder.field("payloads", this.payloads);
        builder.field("preserve_separators", this.preserveSeparators);
        builder.field("preserve_position_increments", this.preservePositionIncrements);
        builder.field("max_input_len", this.maxInputLength);
        return builder.endObject();
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public String value(Object value2) {
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    public boolean isStoringPayloads() {
        return this.payloads;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        CompletionFieldMapper fieldMergeWith = (CompletionFieldMapper)mergeWith;
        if (this.payloads != fieldMergeWith.payloads) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different payload values");
        }
        if (this.preservePositionIncrements != fieldMergeWith.preservePositionIncrements) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different 'preserve_position_increments' values");
        }
        if (this.preserveSeparators != fieldMergeWith.preserveSeparators) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different 'preserve_separators' values");
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.maxInputLength = fieldMergeWith.maxInputLength;
        }
    }

    public static boolean isReservedChar(char character) {
        switch (character) {
            case '\u0000': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        return false;
    }

    private static final class SuggestField
    extends Field {
        private final BytesRef payload;
        private final CompletionTokenStream.ToFiniteStrings toFiniteStrings;

        public SuggestField(String name, Reader value2, FieldType type, BytesRef payload, CompletionTokenStream.ToFiniteStrings toFiniteStrings) {
            super(name, value2, type);
            this.payload = payload;
            this.toFiniteStrings = toFiniteStrings;
        }

        public SuggestField(String name, String value2, FieldType type, BytesRef payload, CompletionTokenStream.ToFiniteStrings toFiniteStrings) {
            super(name, value2, type);
            this.payload = payload;
            this.toFiniteStrings = toFiniteStrings;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer) throws IOException {
            TokenStream ts = super.tokenStream(analyzer);
            return new CompletionTokenStream(ts, this.payload, this.toFiniteStrings);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.completionField(name);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String fieldName = entry2.getKey();
                Object fieldNode = entry2.getValue();
                if (fieldName.equals("type")) continue;
                if (fieldName.equals("analyzer")) {
                    NamedAnalyzer analyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    builder.indexAnalyzer(analyzer);
                    builder.searchAnalyzer(analyzer);
                    continue;
                }
                if (fieldName.equals("index_analyzer") || fieldName.equals("indexAnalyzer")) {
                    builder.indexAnalyzer(this.getNamedAnalyzer(parserContext, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("search_analyzer") || fieldName.equals("searchAnalyzer")) {
                    builder.searchAnalyzer(this.getNamedAnalyzer(parserContext, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("payloads")) {
                    builder.payloads(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("preserve_separators") || fieldName.equals("preserveSeparators")) {
                    builder.preserveSeparators(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("preserve_position_increments") || fieldName.equals("preservePositionIncrements")) {
                    builder.preservePositionIncrements(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("max_input_len") || fieldName.equals("maxInputLen")) {
                    builder.maxInputLength(Integer.parseInt(fieldNode.toString()));
                    continue;
                }
                throw new MapperParsingException("Unknown field [" + fieldName + "]");
            }
            if (builder.searchAnalyzer == null) {
                builder.searchAnalyzer(parserContext.analysisService().analyzer("simple"));
            }
            if (builder.indexAnalyzer == null) {
                builder.indexAnalyzer(parserContext.analysisService().analyzer("simple"));
            }
            builder.postingsFormat(parserContext.postingFormatService().get("default"));
            return builder;
        }

        private NamedAnalyzer getNamedAnalyzer(Mapper.TypeParser.ParserContext parserContext, String name) {
            NamedAnalyzer analyzer = parserContext.analysisService().analyzer(name);
            if (analyzer == null) {
                throw new ElasticSearchIllegalArgumentException("Can't find default or mapped analyzer with name [" + name + "]");
            }
            return analyzer;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.OpenBuilder<Builder, CompletionFieldMapper> {
        private NamedAnalyzer searchAnalyzer;
        private NamedAnalyzer indexAnalyzer;
        private boolean preserveSeparators = true;
        private boolean payloads = false;
        private boolean preservePositionIncrements = true;
        private int maxInputLength = 50;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
        }

        @Override
        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return this;
        }

        @Override
        public Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        public Builder payloads(boolean payloads) {
            this.payloads = payloads;
            return this;
        }

        public Builder preserveSeparators(boolean preserveSeparators) {
            this.preserveSeparators = preserveSeparators;
            return this;
        }

        public Builder preservePositionIncrements(boolean preservePositionIncrements) {
            this.preservePositionIncrements = preservePositionIncrements;
            return this;
        }

        public Builder maxInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new ElasticSearchIllegalArgumentException("max_input_len must be > 0 but was [" + maxInputLength + "]");
            }
            this.maxInputLength = maxInputLength;
            return this;
        }

        @Override
        public CompletionFieldMapper build(Mapper.BuilderContext context) {
            return new CompletionFieldMapper(this.buildNames(context), this.indexAnalyzer, this.searchAnalyzer, this.provider, this.similarity, this.payloads, this.preserveSeparators, this.preservePositionIncrements, this.maxInputLength);
        }
    }

    public static class Fields {
        public static final String ANALYZER = "analyzer";
        public static final String INDEX_ANALYZER = "index_analyzer";
        public static final String SEARCH_ANALYZER = "search_analyzer";
        public static final String PRESERVE_SEPARATORS = "preserve_separators";
        public static final String PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
        public static final String PAYLOADS = "payloads";
        public static final String TYPE = "type";
        public static final String MAX_INPUT_LENGTH = "max_input_len";
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_OUTPUT = "output";
        public static final String CONTENT_FIELD_NAME_PAYLOAD = "payload";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final boolean DEFAULT_HAS_PAYLOADS = false;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

