/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class ByteFieldMapper
extends NumberFieldMapper<Byte> {
    public static final String CONTENT_TYPE = "byte";
    private Byte nullValue;
    private String nullValueAsString;

    protected ByteFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Byte nullValue, Explicit<Boolean> ignoreMalformed, PostingsFormatProvider provider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings) {
        super(names, precisionStep, boost, fieldType, ignoreMalformed, new NamedAnalyzer("_byte/" + precisionStep, new NumericIntegerAnalyzer(precisionStep)), new NamedAnalyzer("_byte/max", new NumericIntegerAnalyzer(Integer.MAX_VALUE)), provider, similarity, normsLoading, fieldDataSettings);
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType(CONTENT_TYPE);
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Byte value(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof BytesRef) {
            return ((BytesRef)value2).bytes[((BytesRef)value2).offset];
        }
        return Byte.parseByte(value2.toString());
    }

    @Override
    public BytesRef indexedValueForSearch(Object value2) {
        BytesRef bytesRef = new BytesRef();
        NumericUtils.intToPrefixCoded(this.parseValue(value2), 0, bytesRef);
        return bytesRef;
    }

    private byte parseValue(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof BytesRef) {
            return Byte.parseByte(((BytesRef)value2).utf8ToString());
        }
        return Byte.parseByte(value2.toString());
    }

    private int parseValueAsInt(Object value2) {
        return this.parseValue(value2);
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions, boolean transpositions) {
        byte iSim;
        byte iValue = Byte.parseByte(value2);
        try {
            iSim = Byte.parseByte(minSim);
        }
        catch (NumberFormatException e) {
            iSim = (byte)Float.parseFloat(minSim);
        }
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        byte iValue = this.parseValue(value2);
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, Integer.valueOf(iValue), Integer.valueOf(iValue), true, true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(this.parseValueAsInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(this.parseValueAsInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        int iValue = this.parseValueAsInt(value2);
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, iValue, iValue, true, true);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(this.parseValueAsInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(this.parseValueAsInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newByteRange((IndexNumericFieldData)fieldData.getForField(this), lowerTerm == null ? null : Byte.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Byte.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, this.nullValue.intValue(), this.nullValue.intValue(), true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException {
        byte value2;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value2 = this.nullValue;
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.nullValue == null) {
                        return null;
                    }
                    value2 = this.nullValue;
                } else {
                    value2 = Byte.parseByte(sExternalValue);
                }
            } else {
                value2 = ((Number)externalValue).byteValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), Byte.toString(value2), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.nullValue == null) {
                    return null;
                }
                value2 = this.nullValue;
                if (this.nullValueAsString != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), this.nullValueAsString, boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token2;
                String currentFieldName = null;
                Byte objValue = this.nullValue;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = (byte)parser.shortValue();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return null;
                }
                value2 = objValue;
            } else {
                value2 = (byte)parser.shortValue();
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), parser.text(), boost);
                }
            }
        }
        CustomByteNumericField field2 = new CustomByteNumericField((NumberFieldMapper)this, value2, this.fieldType);
        field2.setBoost(boost);
        return field2;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((ByteFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((ByteFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", (Object)this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomByteNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final byte number;
        private final NumberFieldMapper mapper;

        public CustomByteNumericField(NumberFieldMapper mapper, byte number2, FieldType fieldType) {
            super(mapper, number2, fieldType);
            this.mapper = mapper;
            this.number = number2;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer) {
            if (this.fieldType().indexed()) {
                return this.mapper.popCachedStream().setIntValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Byte.toString(this.number);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.byteField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry2.getKey());
                Object propNode = entry2.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeByteValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, ByteFieldMapper> {
        protected Byte nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder nullValue(byte nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public ByteFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            ByteFieldMapper fieldMapper = new ByteFieldMapper(this.buildNames(context), this.precisionStep, this.boost, this.fieldType, this.nullValue, this.ignoreMalformed(context), this.provider, this.similarity, this.normsLoading, this.fieldDataSettings);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final Byte NULL_VALUE;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

