/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class BinaryFieldMapper
extends AbstractFieldMapper<BytesReference> {
    public static final String CONTENT_TYPE = "binary";
    private Boolean compress;
    private long compressThreshold;

    protected BinaryFieldMapper(FieldMapper.Names names, FieldType fieldType, Boolean compress, long compressThreshold, PostingsFormatProvider provider) {
        super(names, 1.0f, fieldType, null, null, provider, null, null, null);
        this.compress = compress;
        this.compressThreshold = compressThreshold;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public Object valueForSearch(Object value2) {
        return this.value(value2);
    }

    @Override
    public BytesReference value(Object value2) {
        BytesReference bytes;
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof BytesRef) {
            bytes = new BytesArray((BytesRef)value2);
        } else if (value2 instanceof BytesReference) {
            bytes = (BytesReference)value2;
        } else if (value2 instanceof byte[]) {
            bytes = new BytesArray((byte[])value2);
        } else {
            try {
                bytes = new BytesArray(Base64.decode(value2.toString()));
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to convert bytes", e);
            }
        }
        try {
            return CompressorFactory.uncompressIfNeeded(bytes);
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("failed to decompress source", e);
        }
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.fieldType().stored()) {
            return null;
        }
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        byte[] value2 = context.parser().binaryValue();
        if (this.compress != null && this.compress.booleanValue() && !CompressorFactory.isCompressed(value2, 0, value2.length) && (this.compressThreshold == -1L || (long)value2.length > this.compressThreshold)) {
            BytesStreamOutput bStream = new BytesStreamOutput();
            CompressedStreamOutput stream = CompressorFactory.defaultCompressor().streamOutput(bStream);
            ((StreamOutput)stream).writeBytes(value2, 0, value2.length);
            ((StreamOutput)stream).close();
            value2 = bStream.bytes().toBytes();
        }
        if (value2 == null) {
            return null;
        }
        return new Field(this.names.indexName(), value2, this.fieldType);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        if (includeDefaults || !this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        } else if (includeDefaults) {
            builder.field("compress", false);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        } else if (includeDefaults) {
            builder.field("compress_threshold", -1);
        }
        if (includeDefaults || this.fieldType.stored() != this.defaultFieldType().stored()) {
            builder.field("store", this.fieldType.stored());
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        BinaryFieldMapper sourceMergeWith = (BinaryFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.binaryField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry2 : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry2.getKey());
                Object fieldNode = entry2.getValue();
                if (fieldName.equals("compress") && fieldNode != null) {
                    builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("compress_threshold") || fieldNode == null) continue;
                if (fieldNode instanceof Number) {
                    builder.compressThreshold(((Number)fieldNode).longValue());
                    builder.compress(true);
                    continue;
                }
                builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
                builder.compress(true);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BinaryFieldMapper> {
        private Boolean compress = null;
        private long compressThreshold = -1L;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        @Override
        public Builder indexName(String indexName) {
            return (Builder)super.indexName(indexName);
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            return new BinaryFieldMapper(this.buildNames(context), this.fieldType, this.compress, this.compressThreshold, this.provider);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.freeze();
        }
    }
}

