/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.RegexpFilter;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingFormats;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.FieldDataTermsFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class AbstractFieldMapper<T>
implements FieldMapper<T> {
    protected final FieldMapper.Names names;
    protected float boost;
    protected final FieldType fieldType;
    protected final NamedAnalyzer indexAnalyzer;
    protected NamedAnalyzer searchAnalyzer;
    protected PostingsFormatProvider postingsFormat;
    protected final SimilarityProvider similarity;
    protected FieldMapper.Loading normsLoading;
    protected Settings customFieldDataSettings;
    protected FieldDataType fieldDataType;

    protected AbstractFieldMapper(FieldMapper.Names names, float boost, FieldType fieldType, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsFormat, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings) {
        this.names = names;
        this.boost = boost;
        this.fieldType = fieldType;
        this.fieldType.freeze();
        this.indexAnalyzer = indexAnalyzer == null && !this.fieldType.tokenized() && this.fieldType.indexed() ? Lucene.KEYWORD_ANALYZER : indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer == null && !this.fieldType.tokenized() && this.fieldType.indexed() ? Lucene.KEYWORD_ANALYZER : searchAnalyzer;
        if (postingsFormat == null && this.defaultPostingFormat() != null) {
            postingsFormat = PostingFormats.getAsProvider(this.defaultPostingFormat());
        }
        this.postingsFormat = postingsFormat;
        this.similarity = similarity;
        this.normsLoading = normsLoading;
        this.customFieldDataSettings = fieldDataSettings;
        this.fieldDataType = fieldDataSettings == null ? this.defaultFieldDataType() : new FieldDataType(this.defaultFieldDataType().getType(), ImmutableSettings.builder().put(this.defaultFieldDataType().getSettings()).put(fieldDataSettings));
    }

    @Nullable
    protected String defaultPostingFormat() {
        return null;
    }

    @Override
    public String name() {
        return this.names.name();
    }

    @Override
    public FieldMapper.Names names() {
        return this.names;
    }

    public abstract FieldType defaultFieldType();

    public abstract FieldDataType defaultFieldDataType();

    @Override
    public final FieldDataType fieldDataType() {
        return this.fieldDataType;
    }

    @Override
    public FieldType fieldType() {
        return this.fieldType;
    }

    @Override
    public float boost() {
        return this.boost;
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public Analyzer searchQuoteAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public SimilarityProvider similarity() {
        return this.similarity;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Field field2 = this.parseCreateField(context);
            if (field2 == null) {
                return;
            }
            if (!this.customBoost()) {
                field2.setBoost(this.boost);
            }
            if (context.listener().beforeFieldAdded(this, field2, context)) {
                context.doc().add(field2);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.names.fullName() + "]", e);
        }
    }

    protected abstract Field parseCreateField(ParseContext var1) throws IOException;

    protected boolean customBoost() {
        return false;
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        fieldMapperListener.fieldMapper(this);
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    public Object valueForSearch(Object value2) {
        return value2;
    }

    @Override
    public BytesRef indexedValueForSearch(Object value2) {
        return BytesRefs.toBytesRef(value2);
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return false;
    }

    @Override
    public Query termQuery(Object value2, @Nullable QueryParseContext context) {
        return new TermQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)));
    }

    @Override
    public Filter termFilter(Object value2, @Nullable QueryParseContext context) {
        return new TermFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)));
    }

    @Override
    public Filter termsFilter(List values2, @Nullable QueryParseContext context) {
        BytesRef[] bytesRefs = new BytesRef[values2.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values2.get(i));
        }
        return new TermsFilter(this.names.indexName(), bytesRefs);
    }

    @Override
    public Filter termsFilter(IndexFieldDataService fieldDataService, List values2, @Nullable QueryParseContext context) {
        ObjectOpenHashSet<BytesRef> terms = new ObjectOpenHashSet<BytesRef>((int)((float)values2.size() * 1.75f));
        int len = values2.size();
        for (int i = 0; i < len; ++i) {
            terms.add(this.indexedValueForSearch(values2.get(i)));
        }
        return FieldDataTermsFilter.newBytes(fieldDataService.getForField(this), terms);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return new TermRangeQuery(this.names.indexName(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return new TermRangeFilter(this.names.indexName(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions, boolean transpositions) {
        int edits = FuzzyQuery.floatToEdits(Float.parseFloat(minSim), value2.codePointCount(0, value2.length()));
        return new FuzzyQuery(this.names.createIndexNameTerm(this.indexedValueForSearch(value2)), edits, prefixLength, maxExpansions, transpositions);
    }

    @Override
    public Query prefixQuery(Object value2, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        PrefixQuery query = new PrefixQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)));
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    @Override
    public Filter prefixFilter(Object value2, @Nullable QueryParseContext context) {
        return new PrefixFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)));
    }

    @Override
    public Query regexpQuery(Object value2, int flags, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        RegexpQuery query = new RegexpQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)), flags);
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    @Override
    public Filter regexpFilter(Object value2, int flags, @Nullable QueryParseContext parseContext) {
        return new RegexpFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value2)), flags);
    }

    @Override
    public Filter nullValueFilter() {
        return null;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof AbstractFieldMapper) {
                mergedType = ((AbstractFieldMapper)mergeWith).contentType();
            }
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
            return;
        }
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (this.fieldType().indexed() != fieldMergeWith.fieldType().indexed() || this.fieldType().tokenized() != fieldMergeWith.fieldType().tokenized()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index values");
        }
        if (this.fieldType().stored() != fieldMergeWith.fieldType().stored()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store values");
        }
        if (this.fieldType().tokenized() != fieldMergeWith.fieldType().tokenized()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different tokenize values");
        }
        if (this.fieldType().storeTermVectors() != fieldMergeWith.fieldType().storeTermVectors()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector values");
        }
        if (this.fieldType().storeTermVectorOffsets() != fieldMergeWith.fieldType().storeTermVectorOffsets()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_offsets values");
        }
        if (this.fieldType().storeTermVectorPositions() != fieldMergeWith.fieldType().storeTermVectorPositions()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_positions values");
        }
        if (this.fieldType().storeTermVectorPayloads() != fieldMergeWith.fieldType().storeTermVectorPayloads()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_payloads values");
        }
        if (this.indexAnalyzer == null) {
            if (fieldMergeWith.indexAnalyzer != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
            }
        } else if (fieldMergeWith.indexAnalyzer == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        } else if (!this.indexAnalyzer.name().equals(fieldMergeWith.indexAnalyzer.name())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        }
        if (this.similarity == null) {
            if (fieldMergeWith.similarity() != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
            }
        } else if (fieldMergeWith.similarity() == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
        } else if (!this.similarity().equals(fieldMergeWith.similarity())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.boost = fieldMergeWith.boost;
            this.normsLoading = fieldMergeWith.normsLoading;
            if (fieldMergeWith.postingsFormat != null) {
                this.postingsFormat = fieldMergeWith.postingsFormat;
            }
            if (fieldMergeWith.searchAnalyzer != null) {
                this.searchAnalyzer = fieldMergeWith.searchAnalyzer;
            }
            if (fieldMergeWith.customFieldDataSettings != null && !Objects.equal(fieldMergeWith.customFieldDataSettings, this.customFieldDataSettings)) {
                this.customFieldDataSettings = fieldMergeWith.customFieldDataSettings;
                this.fieldDataType = new FieldDataType(this.defaultFieldDataType().getType(), ImmutableSettings.builder().put(this.defaultFieldDataType().getSettings()).put(this.customFieldDataSettings));
            }
        }
    }

    @Override
    public PostingsFormatProvider postingsFormatProvider() {
        return this.postingsFormat;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.names.name());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        if (includeDefaults || !this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (includeDefaults || this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        FieldType defaultFieldType = this.defaultFieldType();
        if (includeDefaults || this.fieldType.indexed() != defaultFieldType.indexed() || this.fieldType.tokenized() != defaultFieldType.tokenized()) {
            builder.field("index", AbstractFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        if (includeDefaults || this.fieldType.stored() != defaultFieldType.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.fieldType.storeTermVectors() != defaultFieldType.storeTermVectors()) {
            builder.field("term_vector", AbstractFieldMapper.termVectorOptionsToString(this.fieldType));
        }
        if (includeDefaults || this.fieldType.omitNorms() != defaultFieldType.omitNorms() || this.normsLoading != null) {
            builder.startObject("norms");
            if (includeDefaults || this.fieldType.omitNorms() != defaultFieldType.omitNorms()) {
                builder.field("enabled", !this.fieldType.omitNorms());
            }
            if (this.normsLoading != null) {
                builder.field("loading", (Object)this.normsLoading);
            }
            builder.endObject();
        }
        if (includeDefaults || this.fieldType.indexOptions() != defaultFieldType.indexOptions()) {
            builder.field("index_options", AbstractFieldMapper.indexOptionToString(this.fieldType.indexOptions()));
        }
        if (this.indexAnalyzer == null && this.searchAnalyzer == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else if (this.indexAnalyzer == null) {
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_") && !this.searchAnalyzer.name().equals("default")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        } else if (this.searchAnalyzer == null) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
        } else if (this.indexAnalyzer.name().equals(this.searchAnalyzer.name())) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("analyzer", this.indexAnalyzer.name());
            }
        } else {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_") && !this.searchAnalyzer.name().equals("default")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
        if (this.postingsFormat != null) {
            if (includeDefaults || !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
                builder.field("postings_format", this.postingsFormat.name());
            }
        } else if (includeDefaults) {
            String format2 = this.defaultPostingFormat();
            if (format2 == null) {
                format2 = "default";
            }
            builder.field("postings_format", format2);
        }
        if (this.similarity() != null) {
            builder.field("similarity", this.similarity().name());
        } else if (includeDefaults) {
            builder.field("similariry", "default");
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
    }

    protected static String indexOptionToString(FieldInfo.IndexOptions indexOption) {
        switch (indexOption) {
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return "offsets";
            }
            case DOCS_AND_FREQS: {
                return "freqs";
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return "positions";
            }
            case DOCS_ONLY: {
                return "docs";
            }
        }
        throw new ElasticSearchIllegalArgumentException("Unknown IndexOptions [" + (Object)((Object)indexOption) + "]");
    }

    protected static String termVectorOptionsToString(FieldType fieldType) {
        if (!fieldType.storeTermVectors()) {
            return "no";
        }
        if (!fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "yes";
        }
        if (fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "with_offsets";
        }
        StringBuilder builder = new StringBuilder("with");
        if (fieldType.storeTermVectorPositions()) {
            builder.append("_positions");
        }
        if (fieldType.storeTermVectorOffsets()) {
            builder.append("_offsets");
        }
        if (fieldType.storeTermVectorPayloads()) {
            builder.append("_payloads");
        }
        return builder.toString();
    }

    protected static String indexTokenizeOptionToString(boolean indexed, boolean tokenized) {
        if (!indexed) {
            return "no";
        }
        if (tokenized) {
            return "analyzed";
        }
        return "not_analyzed";
    }

    protected abstract String contentType();

    @Override
    public void close() {
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public FieldMapper.Loading normsLoading(FieldMapper.Loading defaultLoading) {
        return this.normsLoading == null ? defaultLoading : this.normsLoading;
    }

    public static abstract class Builder<T extends Builder, Y extends AbstractFieldMapper>
    extends Mapper.Builder<T, Y> {
        protected final FieldType fieldType;
        protected float boost = 1.0f;
        protected boolean omitNormsSet = false;
        protected String indexName;
        protected NamedAnalyzer indexAnalyzer;
        protected NamedAnalyzer searchAnalyzer;
        protected Boolean includeInAll;
        protected boolean indexOptionsSet = false;
        protected PostingsFormatProvider provider;
        protected SimilarityProvider similarity;
        protected FieldMapper.Loading normsLoading;
        @Nullable
        protected Settings fieldDataSettings;

        protected Builder(String name, FieldType fieldType) {
            super(name);
            this.fieldType = fieldType;
        }

        protected T index(boolean index) {
            this.fieldType.setIndexed(index);
            return (T)((Builder)this.builder);
        }

        protected T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        protected T storeTermVectors(boolean termVectors) {
            if (termVectors) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        protected T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        protected T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        protected T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        protected T tokenized(boolean tokenized) {
            this.fieldType.setTokenized(tokenized);
            return (T)((Builder)this.builder);
        }

        protected T boost(float boost) {
            this.boost = boost;
            return (T)((Builder)this.builder);
        }

        protected T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        protected T indexOptions(FieldInfo.IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        protected T indexName(String indexName) {
            this.indexName = indexName;
            return (T)((Builder)this.builder);
        }

        protected T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return (T)((Builder)this.builder);
        }

        protected T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return (T)((Builder)this.builder);
        }

        protected T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        protected T postingsFormat(PostingsFormatProvider postingsFormat) {
            this.provider = postingsFormat;
            return (T)((Builder)this.builder);
        }

        protected T similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
            return (T)((Builder)this.builder);
        }

        public T normsLoading(FieldMapper.Loading normsLoading) {
            this.normsLoading = normsLoading;
            return (T)((Builder)this.builder);
        }

        public T fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (T)((Builder)this.builder);
        }

        protected FieldMapper.Names buildNames(Mapper.BuilderContext context) {
            return new FieldMapper.Names(this.name, this.buildIndexName(context), this.indexName == null ? this.name : this.indexName, this.buildFullName(context), context.path().sourcePath());
        }

        protected String buildIndexName(Mapper.BuilderContext context) {
            String actualIndexName = this.indexName == null ? this.name : this.indexName;
            return context.path().pathAsText(actualIndexName);
        }

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().fullPathAsText(this.name);
        }
    }

    public static abstract class OpenBuilder<T extends Builder, Y extends AbstractFieldMapper>
    extends Builder<T, Y> {
        protected OpenBuilder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        @Override
        public T index(boolean index) {
            return super.index(index);
        }

        @Override
        public T store(boolean store) {
            return super.store(store);
        }

        @Override
        public T storeTermVectors(boolean termVectors) {
            return super.storeTermVectors(termVectors);
        }

        @Override
        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            return super.storeTermVectorOffsets(termVectorOffsets);
        }

        @Override
        public T storeTermVectorPositions(boolean termVectorPositions) {
            return super.storeTermVectorPositions(termVectorPositions);
        }

        @Override
        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            return super.storeTermVectorPayloads(termVectorPayloads);
        }

        @Override
        public T tokenized(boolean tokenized) {
            return super.tokenized(tokenized);
        }

        @Override
        public T boost(float boost) {
            return super.boost(boost);
        }

        @Override
        public T omitNorms(boolean omitNorms) {
            return super.omitNorms(omitNorms);
        }

        @Override
        public T indexOptions(FieldInfo.IndexOptions indexOptions) {
            return super.indexOptions(indexOptions);
        }

        @Override
        public T indexName(String indexName) {
            return super.indexName(indexName);
        }

        @Override
        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            return super.indexAnalyzer(indexAnalyzer);
        }

        @Override
        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            return super.searchAnalyzer(searchAnalyzer);
        }

        @Override
        public T similarity(SimilarityProvider similarity) {
            return super.similarity(similarity);
        }

        @Override
        public T fieldDataSettings(Settings settings) {
            return super.fieldDataSettings(settings);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final float BOOST = 1.0f;

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }
}

