/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.FilterClause;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatService;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersLookup;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ObjectMappers;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;

public class MapperService
extends AbstractIndexComponent
implements Iterable<DocumentMapper> {
    public static final String DEFAULT_MAPPING = "_default_";
    private final AnalysisService analysisService;
    private final IndexFieldDataService fieldDataService;
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile Map<String, DocumentMapper> mappers;
    private final Object typeMutex;
    private final Object mappersMutex;
    private final FieldMappersLookup fieldMappers;
    private volatile ImmutableOpenMap<String, ObjectMappers> fullPathObjectMappers;
    private boolean hasNested;
    private final DocumentMapperParser documentParser;
    private final InternalFieldMapperListener fieldMapperListener;
    private final InternalObjectMapperListener objectMapperListener;
    private final SmartIndexNameSearchAnalyzer searchAnalyzer;
    private final SmartIndexNameSearchQuoteAnalyzer searchQuoteAnalyzer;

    @Inject
    public MapperService(Index index, @IndexSettings Settings indexSettings, Environment environment, AnalysisService analysisService, IndexFieldDataService fieldDataService, PostingsFormatService postingsFormatService, SimilarityLookupService similarityLookupService) {
        URL defaultMappingUrl;
        String defaultMappingLocation;
        block15: {
            super(index, indexSettings);
            this.mappers = ImmutableMap.of();
            this.typeMutex = new Object();
            this.mappersMutex = new Object();
            this.fieldMappers = new FieldMappersLookup();
            this.fullPathObjectMappers = ImmutableOpenMap.of();
            this.hasNested = false;
            this.fieldMapperListener = new InternalFieldMapperListener();
            this.objectMapperListener = new InternalObjectMapperListener();
            this.analysisService = analysisService;
            this.fieldDataService = fieldDataService;
            this.documentParser = new DocumentMapperParser(index, indexSettings, analysisService, postingsFormatService, similarityLookupService);
            this.searchAnalyzer = new SmartIndexNameSearchAnalyzer(analysisService.defaultSearchAnalyzer());
            this.searchQuoteAnalyzer = new SmartIndexNameSearchQuoteAnalyzer(analysisService.defaultSearchQuoteAnalyzer());
            this.dynamic = this.componentSettings.getAsBoolean("dynamic", (Boolean)true);
            defaultMappingLocation = this.componentSettings.get("default_mapping_location");
            if (defaultMappingLocation == null) {
                try {
                    defaultMappingUrl = environment.resolveConfig("default-mapping.json");
                }
                catch (FailedToResolveConfigException e) {
                    defaultMappingUrl = indexSettings.getClassLoader().getResource("org/elasticsearch/index/mapper/default-mapping.json");
                    if (defaultMappingUrl == null) {
                        defaultMappingUrl = MapperService.class.getClassLoader().getResource("org/elasticsearch/index/mapper/default-mapping.json");
                    }
                    break block15;
                }
            }
            try {
                defaultMappingUrl = environment.resolveConfig(defaultMappingLocation);
            }
            catch (FailedToResolveConfigException e) {
                try {
                    defaultMappingUrl = new File(defaultMappingLocation).toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new FailedToResolveConfigException("Failed to resolve dynamic mapping location [" + defaultMappingLocation + "]");
                }
            }
        }
        if (defaultMappingUrl == null) {
            this.logger.info("failed to find default-mapping.json in the classpath, using the default template", new Object[0]);
            this.defaultMappingSource = "{\n    \"_default_\":{\n    }\n}";
        } else {
            try {
                this.defaultMappingSource = Streams.copyToString(new InputStreamReader(defaultMappingUrl.openStream(), Charsets.UTF_8));
            }
            catch (IOException e) {
                throw new MapperException("Failed to load default mapping source from [" + defaultMappingLocation + "]", e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using dynamic[{}], default mapping: default_mapping_location[{}], loaded_from[{}]", this.dynamic, defaultMappingLocation, defaultMappingUrl);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("using dynamic[{}], default mapping: default_mapping_location[{}], loaded_from[{}] and source[{}]", this.dynamic, defaultMappingLocation, defaultMappingUrl, this.defaultMappingSource);
        }
    }

    public void close() {
        for (DocumentMapper documentMapper : this.mappers.values()) {
            documentMapper.close();
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    @Override
    public UnmodifiableIterator<DocumentMapper> iterator() {
        return Iterators.unmodifiableIterator(this.mappers.values().iterator());
    }

    public AnalysisService analysisService() {
        return this.analysisService;
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMapper merge(String type, CompressedString mappingSource, boolean applyDefault) {
        if (DEFAULT_MAPPING.equals(type)) {
            DocumentMapper mapper = this.documentParser.parseCompressed(type, mappingSource);
            Object object = this.typeMutex;
            synchronized (object) {
                this.mappers = MapBuilder.newMapBuilder(this.mappers).put(type, mapper).map();
            }
            try {
                this.defaultMappingSource = mappingSource.string();
            }
            catch (IOException e) {
                throw new ElasticSearchGenerationException("failed to un-compress", e);
            }
            return mapper;
        }
        return this.merge(this.parse(type, mappingSource, applyDefault));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentMapper merge(DocumentMapper mapper) {
        Object object = this.typeMutex;
        synchronized (object) {
            DocumentMapper oldMapper;
            if (mapper.type().length() == 0) {
                throw new InvalidTypeNameException("mapping type name is empty");
            }
            if (mapper.type().charAt(0) == '_') {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] can't start with '_'");
            }
            if (mapper.type().contains("#")) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include '#' in it");
            }
            if (mapper.type().contains(",")) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include ',' in it");
            }
            if (mapper.type().contains(".")) {
                this.logger.warn("Type [{}] contains a '.', it is recommended not to include it within a type name", mapper.type());
            }
            if ((oldMapper = this.mappers.get(mapper.type())) != null) {
                DocumentMapper.MergeResult result2 = oldMapper.merge(mapper, DocumentMapper.MergeFlags.mergeFlags().simulate(false));
                if (result2.hasConflicts() && this.logger.isDebugEnabled()) {
                    this.logger.debug("merging mapping for type [{}] resulted in conflicts: [{}]", mapper.type(), Arrays.toString(result2.conflicts()));
                }
                this.fieldDataService.onMappingUpdate();
                return oldMapper;
            }
            FieldMapperListener.Aggregator fieldMappersAgg = new FieldMapperListener.Aggregator();
            mapper.traverse(fieldMappersAgg);
            this.addFieldMappers(fieldMappersAgg.mappers.toArray(new FieldMapper[fieldMappersAgg.mappers.size()]));
            mapper.addFieldMapperListener(this.fieldMapperListener, false);
            ObjectMapperListener.Aggregator objectMappersAgg = new ObjectMapperListener.Aggregator();
            mapper.traverse(objectMappersAgg);
            this.addObjectMappers(objectMappersAgg.mappers.toArray(new ObjectMapper[objectMappersAgg.mappers.size()]));
            mapper.addObjectMapperListener(this.objectMapperListener, false);
            this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mapper.type(), mapper).map();
            return mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectMappers(ObjectMapper[] objectMappers) {
        Object object = this.mappersMutex;
        synchronized (object) {
            ImmutableOpenMap.Builder<String, ObjectMappers> fullPathObjectMappers = ImmutableOpenMap.builder(this.fullPathObjectMappers);
            for (ObjectMapper objectMapper : objectMappers) {
                ObjectMappers mappers = fullPathObjectMappers.get(objectMapper.fullPath());
                mappers = mappers == null ? new ObjectMappers(objectMapper) : mappers.concat(objectMapper);
                fullPathObjectMappers.put(objectMapper.fullPath(), mappers);
                if (!objectMapper.nested().isNested()) continue;
                this.hasNested = true;
            }
            this.fullPathObjectMappers = fullPathObjectMappers.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFieldMappers(FieldMapper[] fieldMappers) {
        Object object = this.mappersMutex;
        synchronized (object) {
            this.fieldMappers.addNewMappers(Arrays.asList(fieldMappers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String type) {
        Object object = this.typeMutex;
        synchronized (object) {
            DocumentMapper docMapper = this.mappers.get(type);
            if (docMapper == null) {
                return;
            }
            docMapper.close();
            this.mappers = MapBuilder.newMapBuilder(this.mappers).remove(type).map();
            this.removeObjectAndFieldMappers(docMapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObjectAndFieldMappers(DocumentMapper docMapper) {
        Object object = this.mappersMutex;
        synchronized (object) {
            this.fieldMappers.removeMappers(docMapper.mappers());
            ImmutableOpenMap.Builder<String, ObjectMappers> fullPathObjectMappers = ImmutableOpenMap.builder(this.fullPathObjectMappers);
            for (ObjectMapper mapper : docMapper.objectMappers().values()) {
                ObjectMappers mappers = fullPathObjectMappers.get(mapper.fullPath());
                if (mappers == null) continue;
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    fullPathObjectMappers.remove(mapper.fullPath());
                    continue;
                }
                fullPathObjectMappers.put(mapper.fullPath(), mappers);
            }
            this.fullPathObjectMappers = fullPathObjectMappers.build();
        }
    }

    public DocumentMapper parse(String mappingType, CompressedString mappingSource) throws MapperParsingException {
        return this.parse(mappingType, mappingSource, true);
    }

    public DocumentMapper parse(String mappingType, CompressedString mappingSource, boolean applyDefault) throws MapperParsingException {
        return this.documentParser.parseCompressed(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public Collection<String> types() {
        return this.mappers.keySet();
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMapper documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return mapper;
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index, type, "trying to auto create mapping, but dynamic mapping is disabled");
        }
        Object object = this.typeMutex;
        synchronized (object) {
            mapper = this.mappers.get(type);
            if (mapper != null) {
                return mapper;
            }
            this.merge(type, null, true);
            return this.mappers.get(type);
        }
    }

    @Nullable
    public Filter searchFilter(String ... types) {
        if (types == null || types.length == 0) {
            if (this.hasNested) {
                return NonNestedDocsFilter.INSTANCE;
            }
            return null;
        }
        if (types.length == 1) {
            DocumentMapper docMapper = this.documentMapper(types[0]);
            if (docMapper == null) {
                return new TermFilter(new Term(types[0]));
            }
            return docMapper.typeFilter();
        }
        boolean useTermsFilter = true;
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                useTermsFilter = false;
                break;
            }
            if (docMapper.typeMapper().fieldType().indexed()) continue;
            useTermsFilter = false;
            break;
        }
        if (useTermsFilter) {
            BytesRef[] typesBytes = new BytesRef[types.length];
            for (int i = 0; i < typesBytes.length; ++i) {
                typesBytes[i] = new BytesRef(types[i]);
            }
            return new TermsFilter("_type", typesBytes);
        }
        XBooleanFilter bool2 = new XBooleanFilter();
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                bool2.add(new FilterClause(new TermFilter(new Term("_type", type)), BooleanClause.Occur.SHOULD));
                continue;
            }
            bool2.add(new FilterClause(docMapper.typeFilter(), BooleanClause.Occur.SHOULD));
        }
        return bool2;
    }

    public FieldMappers name(String name) {
        return this.fieldMappers.name(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.fieldMappers.indexName(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fieldMappers.fullName(fullName);
    }

    public ObjectMappers objectMapper(String path) {
        return this.fullPathObjectMappers.get(path);
    }

    public Set<String> simpleMatchToIndexNames(String pattern, @Nullable String[] types) {
        if (types == null || types.length == 0) {
            return this.simpleMatchToIndexNames(pattern);
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.simpleMatchToIndexNames(pattern);
        }
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return ImmutableSet.of(pattern);
        }
        HashSet<String> fields = Sets.newHashSet();
        for (String type : types) {
            DocumentMapper possibleDocMapper = this.mappers.get(type);
            if (possibleDocMapper == null) continue;
            for (String indexName : possibleDocMapper.mappers().simpleMatchToIndexNames(pattern)) {
                fields.add(indexName);
            }
        }
        return fields;
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        String possibleType;
        DocumentMapper possibleDocMapper;
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return ImmutableSet.of(pattern);
        }
        int dotIndex = pattern.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = pattern.substring(0, dotIndex))) != null) {
            HashSet<String> typedFields = Sets.newHashSet();
            for (String indexName : possibleDocMapper.mappers().simpleMatchToIndexNames(pattern)) {
                typedFields.add(possibleType + "." + indexName);
            }
            return typedFields;
        }
        return this.fieldMappers.simpleMatchToIndexNames(pattern);
    }

    public SmartNameObjectMapper smartNameObjectMapper(String smartName, @Nullable String[] types) {
        String possibleType;
        DocumentMapper possibleDocMapper;
        if (types == null || types.length == 0) {
            return this.smartNameObjectMapper(smartName);
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.smartNameObjectMapper(smartName);
        }
        for (String type : types) {
            ObjectMapper mapper;
            DocumentMapper possibleDocMapper2 = this.mappers.get(type);
            if (possibleDocMapper2 == null || (mapper = possibleDocMapper2.objectMappers().get(smartName)) == null) continue;
            return new SmartNameObjectMapper(mapper, possibleDocMapper2);
        }
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possiblePath = smartName.substring(dotIndex + 1);
            ObjectMapper mapper = possibleDocMapper.objectMappers().get(possiblePath);
            if (mapper != null) {
                return new SmartNameObjectMapper(mapper, possibleDocMapper);
            }
        }
        return null;
    }

    public SmartNameObjectMapper smartNameObjectMapper(String smartName) {
        ObjectMappers mappers;
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possiblePath = smartName.substring(dotIndex + 1);
            ObjectMapper mapper = possibleDocMapper.objectMappers().get(possiblePath);
            if (mapper != null) {
                return new SmartNameObjectMapper(mapper, possibleDocMapper);
            }
        }
        if ((mappers = this.objectMapper(smartName)) != null) {
            return new SmartNameObjectMapper(mappers.mapper(), null);
        }
        return null;
    }

    public FieldMapper smartNameFieldMapper(String smartName) {
        FieldMappers fieldMappers = this.smartNameFieldMappers(smartName);
        if (fieldMappers != null) {
            return fieldMappers.mapper();
        }
        return null;
    }

    public FieldMapper smartNameFieldMapper(String smartName, @Nullable String[] types) {
        FieldMappers fieldMappers = this.smartNameFieldMappers(smartName, types);
        if (fieldMappers != null) {
            return fieldMappers.mapper();
        }
        return null;
    }

    public FieldMappers smartNameFieldMappers(String smartName, @Nullable String[] types) {
        String possibleType;
        DocumentMapper possibleDocMapper;
        if (types == null || types.length == 0) {
            return this.smartNameFieldMappers(smartName);
        }
        for (String type : types) {
            FieldMappers mappers;
            DocumentMapper documentMapper = this.mappers.get(type);
            if (documentMapper == null || (mappers = documentMapper.mappers().smartName(smartName)) == null) continue;
            return mappers;
        }
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers != null) {
                return mappers;
            }
        }
        return null;
    }

    public FieldMappers smartNameFieldMappers(String smartName) {
        FieldMappers mappers;
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers2 = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers2 != null) {
                return mappers2;
            }
        }
        if ((mappers = this.fullName(smartName)) != null) {
            return mappers;
        }
        mappers = this.indexName(smartName);
        if (mappers != null) {
            return mappers;
        }
        return this.name(smartName);
    }

    public SmartNameFieldMappers smartName(String smartName, @Nullable String[] types) {
        String possibleType;
        DocumentMapper possibleDocMapper;
        if (types == null || types.length == 0) {
            return this.smartName(smartName);
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.smartName(smartName);
        }
        for (String type : types) {
            FieldMappers mappers;
            DocumentMapper documentMapper = this.mappers.get(type);
            if (documentMapper == null || (mappers = documentMapper.mappers().smartName(smartName)) == null) continue;
            return new SmartNameFieldMappers(this, mappers, documentMapper, false);
        }
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers != null) {
                return new SmartNameFieldMappers(this, mappers, possibleDocMapper, true);
            }
        }
        return null;
    }

    public SmartNameFieldMappers smartName(String smartName) {
        FieldMappers fieldMappers;
        String possibleType;
        DocumentMapper possibleDocMapper;
        int dotIndex = smartName.indexOf(46);
        if (dotIndex != -1 && (possibleDocMapper = this.mappers.get(possibleType = smartName.substring(0, dotIndex))) != null) {
            String possibleName = smartName.substring(dotIndex + 1);
            FieldMappers mappers = possibleDocMapper.mappers().smartName(possibleName);
            if (mappers != null) {
                return new SmartNameFieldMappers(this, mappers, possibleDocMapper, true);
            }
        }
        if ((fieldMappers = this.fullName(smartName)) != null) {
            return new SmartNameFieldMappers(this, fieldMappers, null, false);
        }
        fieldMappers = this.indexName(smartName);
        if (fieldMappers != null) {
            return new SmartNameFieldMappers(this, fieldMappers, null, false);
        }
        fieldMappers = this.name(smartName);
        if (fieldMappers != null) {
            return new SmartNameFieldMappers(this, fieldMappers, null, false);
        }
        return null;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public Analyzer fieldSearchAnalyzer(String field2) {
        return this.searchAnalyzer.getWrappedAnalyzer(field2);
    }

    public Analyzer fieldSearchQuoteAnalyzer(String field2) {
        return this.searchQuoteAnalyzer.getWrappedAnalyzer(field2);
    }

    public ObjectMapper resolveClosestNestedObjectMapper(String fieldName) {
        String objectPath;
        int indexOf2 = fieldName.lastIndexOf(46);
        if (indexOf2 == -1) {
            return null;
        }
        do {
            ObjectMappers objectMappers;
            if ((objectMappers = this.objectMapper(objectPath = fieldName.substring(0, indexOf2))) == null) {
                return null;
            }
            if (!objectMappers.hasNested()) continue;
            for (ObjectMapper objectMapper : objectMappers) {
                if (!objectMapper.nested().isNested()) continue;
                return objectMapper;
            }
        } while ((indexOf2 = objectPath.lastIndexOf(46)) != -1);
        return null;
    }

    class InternalObjectMapperListener
    extends ObjectMapperListener {
        InternalObjectMapperListener() {
        }

        @Override
        public void objectMapper(ObjectMapper objectMapper) {
            MapperService.this.addObjectMappers(new ObjectMapper[]{objectMapper});
        }

        @Override
        public void objectMappers(ObjectMapper ... objectMappers) {
            MapperService.this.addObjectMappers(objectMappers);
        }
    }

    class InternalFieldMapperListener
    extends FieldMapperListener {
        InternalFieldMapperListener() {
        }

        @Override
        public void fieldMapper(FieldMapper fieldMapper) {
            MapperService.this.addFieldMappers(new FieldMapper[]{fieldMapper});
        }

        @Override
        public void fieldMappers(FieldMapper ... fieldMappers) {
            MapperService.this.addFieldMappers(fieldMappers);
        }
    }

    final class SmartIndexNameSearchQuoteAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer defaultAnalyzer;

        SmartIndexNameSearchQuoteAnalyzer(Analyzer defaultAnalyzer) {
            this.defaultAnalyzer = defaultAnalyzer;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            FieldMappers mappers;
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchQuoteAnalyzer();
                }
            }
            if ((mappers = MapperService.this.fieldMappers.fullName(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchQuoteAnalyzer() != null) {
                return mappers.mapper().searchQuoteAnalyzer();
            }
            mappers = MapperService.this.fieldMappers.indexName(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchQuoteAnalyzer() != null) {
                return mappers.mapper().searchQuoteAnalyzer();
            }
            return this.defaultAnalyzer;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return components;
        }
    }

    final class SmartIndexNameSearchAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer defaultAnalyzer;

        SmartIndexNameSearchAnalyzer(Analyzer defaultAnalyzer) {
            this.defaultAnalyzer = defaultAnalyzer;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            FieldMappers mappers;
            int dotIndex = fieldName.indexOf(46);
            if (dotIndex != -1) {
                String possibleType = fieldName.substring(0, dotIndex);
                DocumentMapper possibleDocMapper = (DocumentMapper)MapperService.this.mappers.get(possibleType);
                if (possibleDocMapper != null) {
                    return possibleDocMapper.mappers().searchAnalyzer();
                }
            }
            if ((mappers = MapperService.this.fieldMappers.fullName(fieldName)) != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer();
            }
            mappers = MapperService.this.fieldMappers.indexName(fieldName);
            if (mappers != null && mappers.mapper() != null && mappers.mapper().searchAnalyzer() != null) {
                return mappers.mapper().searchAnalyzer();
            }
            return this.defaultAnalyzer;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return components;
        }
    }

    public static class SmartNameFieldMappers {
        private final MapperService mapperService;
        private final FieldMappers fieldMappers;
        private final DocumentMapper docMapper;
        private final boolean explicitTypeInName;

        public SmartNameFieldMappers(MapperService mapperService, FieldMappers fieldMappers, @Nullable DocumentMapper docMapper, boolean explicitTypeInName) {
            this.mapperService = mapperService;
            this.fieldMappers = fieldMappers;
            this.docMapper = docMapper;
            this.explicitTypeInName = explicitTypeInName;
        }

        public boolean hasMapper() {
            return !this.fieldMappers.isEmpty();
        }

        public FieldMapper mapper() {
            return this.fieldMappers.mapper();
        }

        public FieldMappers fieldMappers() {
            return this.fieldMappers;
        }

        public boolean hasDocMapper() {
            return this.docMapper != null;
        }

        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        public boolean explicitTypeInName() {
            return this.explicitTypeInName;
        }

        public boolean explicitTypeInNameWithDocMapper() {
            return this.explicitTypeInName && this.docMapper != null;
        }

        public Analyzer searchAnalyzer() {
            Analyzer analyzer;
            if (this.hasMapper() && (analyzer = this.mapper().searchAnalyzer()) != null) {
                return analyzer;
            }
            if (this.docMapper != null && this.docMapper.searchAnalyzer() != null) {
                return this.docMapper.searchAnalyzer();
            }
            return this.mapperService.searchAnalyzer();
        }

        public Analyzer searchQuoteAnalyzer() {
            Analyzer analyzer;
            if (this.hasMapper() && (analyzer = this.mapper().searchQuoteAnalyzer()) != null) {
                return analyzer;
            }
            if (this.docMapper != null && this.docMapper.searchQuotedAnalyzer() != null) {
                return this.docMapper.searchQuotedAnalyzer();
            }
            return this.mapperService.searchQuoteAnalyzer();
        }
    }

    public static class SmartNameObjectMapper {
        private final ObjectMapper mapper;
        private final DocumentMapper docMapper;

        public SmartNameObjectMapper(ObjectMapper mapper, @Nullable DocumentMapper docMapper) {
            this.mapper = mapper;
            this.docMapper = docMapper;
        }

        public boolean hasMapper() {
            return this.mapper != null;
        }

        public ObjectMapper mapper() {
            return this.mapper;
        }

        public boolean hasDocMapper() {
            return this.docMapper != null;
        }

        public DocumentMapper docMapper() {
            return this.docMapper;
        }
    }
}

