/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.indexing;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.slowlog.ShardSlowLogIndexingService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardIndexingService
extends AbstractIndexShardComponent {
    private final ShardSlowLogIndexingService slowLog;
    private final StatsHolder totalStats = new StatsHolder();
    private final CopyOnWriteArrayList<IndexingOperationListener> listeners = new CopyOnWriteArrayList();
    private volatile Map<String, StatsHolder> typesStats = ImmutableMap.of();

    @Inject
    public ShardIndexingService(ShardId shardId, @IndexSettings Settings indexSettings, ShardSlowLogIndexingService slowLog) {
        super(shardId, indexSettings);
        this.slowLog = slowLog;
    }

    public IndexingStats stats(String ... types) {
        HashMap<String, IndexingStats.Stats> typesSt;
        IndexingStats.Stats total;
        block4: {
            total = this.totalStats.stats();
            typesSt = null;
            if (types == null || types.length <= 0) break block4;
            if (types.length == 1 && types[0].equals("_all")) {
                typesSt = new HashMap(this.typesStats.size());
                for (Map.Entry<String, StatsHolder> entry2 : this.typesStats.entrySet()) {
                    typesSt.put(entry2.getKey(), entry2.getValue().stats());
                }
            } else {
                typesSt = new HashMap<String, IndexingStats.Stats>(types.length);
                for (String type : types) {
                    StatsHolder statsHolder = this.typesStats.get(type);
                    if (statsHolder == null) continue;
                    typesSt.put(type, statsHolder.stats());
                }
            }
        }
        return new IndexingStats(total, typesSt);
    }

    public void addListener(IndexingOperationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IndexingOperationListener listener) {
        this.listeners.remove(listener);
    }

    public Engine.Create preCreate(Engine.Create create2) {
        this.totalStats.indexCurrent.inc();
        this.typeStats((String)create2.type()).indexCurrent.inc();
        for (IndexingOperationListener listener : this.listeners) {
            create2 = listener.preCreate(create2);
        }
        return create2;
    }

    public void postCreateUnderLock(Engine.Create create2) {
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postCreateUnderLock(create2);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public void postCreate(Engine.Create create2) {
        long took = create2.endTime() - create2.startTime();
        this.totalStats.indexMetric.inc(took);
        this.totalStats.indexCurrent.dec();
        StatsHolder typeStats = this.typeStats(create2.type());
        typeStats.indexMetric.inc(took);
        typeStats.indexCurrent.dec();
        this.slowLog.postCreate(create2, took);
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postCreate(create2);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public Engine.Index preIndex(Engine.Index index) {
        this.totalStats.indexCurrent.inc();
        this.typeStats((String)index.type()).indexCurrent.inc();
        for (IndexingOperationListener listener : this.listeners) {
            index = listener.preIndex(index);
        }
        return index;
    }

    public void postIndexUnderLock(Engine.Index index) {
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postIndexUnderLock(index);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public void postIndex(Engine.Index index) {
        long took = index.endTime() - index.startTime();
        this.totalStats.indexMetric.inc(took);
        this.totalStats.indexCurrent.dec();
        StatsHolder typeStats = this.typeStats(index.type());
        typeStats.indexMetric.inc(took);
        typeStats.indexCurrent.dec();
        this.slowLog.postIndex(index, took);
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postIndex(index);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public void failedIndex(Engine.Index index) {
        this.totalStats.indexCurrent.dec();
        this.typeStats((String)index.type()).indexCurrent.dec();
    }

    public Engine.Delete preDelete(Engine.Delete delete2) {
        this.totalStats.deleteCurrent.inc();
        this.typeStats((String)delete2.type()).deleteCurrent.inc();
        for (IndexingOperationListener listener : this.listeners) {
            delete2 = listener.preDelete(delete2);
        }
        return delete2;
    }

    public void postDeleteUnderLock(Engine.Delete delete2) {
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postDeleteUnderLock(delete2);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public void postDelete(Engine.Delete delete2) {
        long took = delete2.endTime() - delete2.startTime();
        this.totalStats.deleteMetric.inc(took);
        this.totalStats.deleteCurrent.dec();
        StatsHolder typeStats = this.typeStats(delete2.type());
        typeStats.deleteMetric.inc(took);
        typeStats.deleteCurrent.dec();
        for (IndexingOperationListener listener : this.listeners) {
            try {
                listener.postDelete(delete2);
            }
            catch (Exception e) {
                this.logger.warn("post listener [{}] failed", e, listener);
            }
        }
    }

    public void failedDelete(Engine.Delete delete2) {
        this.totalStats.deleteCurrent.dec();
        this.typeStats((String)delete2.type()).deleteCurrent.dec();
    }

    public Engine.DeleteByQuery preDeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
        for (IndexingOperationListener listener : this.listeners) {
            deleteByQuery = listener.preDeleteByQuery(deleteByQuery);
        }
        return deleteByQuery;
    }

    public void postDeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
        for (IndexingOperationListener listener : this.listeners) {
            listener.postDeleteByQuery(deleteByQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.totalStats.clear();
        ShardIndexingService shardIndexingService = this;
        synchronized (shardIndexingService) {
            if (!this.typesStats.isEmpty()) {
                MapBuilder<String, StatsHolder> typesStatsBuilder = MapBuilder.newMapBuilder();
                for (Map.Entry<String, StatsHolder> typeStats : this.typesStats.entrySet()) {
                    if (typeStats.getValue().totalCurrent() <= 0L) continue;
                    typeStats.getValue().clear();
                    typesStatsBuilder.put(typeStats.getKey(), typeStats.getValue());
                }
                this.typesStats = typesStatsBuilder.immutableMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder typeStats(String type) {
        StatsHolder stats = this.typesStats.get(type);
        if (stats == null) {
            ShardIndexingService shardIndexingService = this;
            synchronized (shardIndexingService) {
                stats = this.typesStats.get(type);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.typesStats = MapBuilder.newMapBuilder(this.typesStats).put(type, stats).immutableMap();
                }
            }
        }
        return stats;
    }

    static class StatsHolder {
        public final MeanMetric indexMetric = new MeanMetric();
        public final MeanMetric deleteMetric = new MeanMetric();
        public final CounterMetric indexCurrent = new CounterMetric();
        public final CounterMetric deleteCurrent = new CounterMetric();

        StatsHolder() {
        }

        public IndexingStats.Stats stats() {
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.indexMetric.sum()), this.indexCurrent.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count());
        }

        public long totalCurrent() {
            return this.indexCurrent.count() + this.deleteMetric.count();
        }

        public void clear() {
            this.indexMetric.clear();
            this.deleteMetric.clear();
        }
    }
}

