/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class ShardGetService
extends AbstractIndexShardComponent {
    private final ScriptService scriptService;
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    private IndexShard indexShard;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardGetService(ShardId shardId, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexFieldDataService fieldDataService) {
        super(shardId, indexSettings);
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public ShardGetService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String type, String[] fields) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            DocumentMapper docMapper = this.mapperService.documentMapper(type);
            if (docMapper == null) {
                this.missingMetric.inc(System.nanoTime() - now);
                GetResult getResult = new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
                return getResult;
            }
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, fields, engineGetResult, docMapper);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult innerGet(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        DocumentMapper docMapper;
        boolean loadSource = gFields == null || gFields.length > 0;
        Engine.GetResult get2 = null;
        if (type == null || ((String)type).equals("_all")) {
            for (String string2 : this.mapperService.types()) {
                get2 = this.indexShard.get(new Engine.Get(realtime, new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(string2, id))).loadSource(loadSource));
                if (get2.exists()) {
                    type = string2;
                    break;
                }
                get2.release();
            }
            if (get2 == null) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
            if (!get2.exists()) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        } else {
            get2 = this.indexShard.get(new Engine.Get(realtime, new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)type, id))).loadSource(loadSource));
            if (!get2.exists()) {
                get2.release();
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        }
        if ((docMapper = this.mapperService.documentMapper((String)type)) == null) {
            get2.release();
            return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
        }
        try {
            if (get2.docIdAndVersion() != null) {
                GetResult getResult = this.innerGetLoadFromStoredFields((String)type, id, gFields, get2, docMapper);
                return getResult;
            }
            Translog.Source source = get2.source();
            HashMap<String, GetField> fields = null;
            boolean sourceRequested = false;
            if (gFields == null) {
                sourceRequested = true;
            } else if (gFields.length == 0) {
                sourceRequested = false;
            } else {
                Map<String, Object> sourceAsMap = null;
                SearchLookup searchLookup = null;
                for (String field2 : gFields) {
                    if (field2.equals("_source")) {
                        sourceRequested = true;
                        continue;
                    }
                    Object value2 = null;
                    if (field2.equals("_routing") && docMapper.routingFieldMapper().fieldType().stored()) {
                        value2 = source.routing;
                    } else if (field2.equals("_parent") && docMapper.parentFieldMapper().active() && docMapper.parentFieldMapper().fieldType().stored()) {
                        value2 = source.parent;
                    } else if (field2.equals("_timestamp") && docMapper.timestampFieldMapper().fieldType().stored()) {
                        value2 = source.timestamp;
                    } else if (field2.equals("_ttl") && docMapper.TTLFieldMapper().fieldType().stored()) {
                        if (source.ttl > 0L) {
                            value2 = docMapper.TTLFieldMapper().valueForSearch(source.timestamp + source.ttl);
                        }
                    } else if (field2.equals("_size") && docMapper.rootMapper(SizeFieldMapper.class).fieldType().stored()) {
                        value2 = source.source.length();
                    } else if (field2.contains("_source.")) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                        }
                        if (sourceAsMap == null) {
                            sourceAsMap = SourceLookup.sourceAsMap(source.source);
                        }
                        SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field2, null);
                        searchScript.setNextSource(sourceAsMap);
                        try {
                            value2 = searchScript.run();
                        }
                        catch (RuntimeException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("failed to execute get request script field [{}]", e, field2);
                            }
                        }
                    } else {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                            searchLookup.source().setNextSource(source.source);
                        }
                        FieldMapper x2 = docMapper.mappers().smartNameFieldMapper(field2);
                        if ((docMapper.sourceMapper().enabled() || x2 == null || x2.fieldType().stored()) && (value2 = searchLookup.source().extractValue(field2)) != null && x2 != null) {
                            if (value2 instanceof List) {
                                List list2 = (List)value2;
                                for (int i = 0; i < list2.size(); ++i) {
                                    list2.set(i, x2.valueForSearch(list2.get(i)));
                                }
                            } else {
                                value2 = x2.valueForSearch(value2);
                            }
                        }
                    }
                    if (value2 == null) continue;
                    if (fields == null) {
                        fields = Maps.newHashMapWithExpectedSize(2);
                    }
                    if (value2 instanceof List) {
                        fields.put(field2, new GetField(field2, (List)value2));
                        continue;
                    }
                    fields.put(field2, new GetField(field2, ImmutableList.of(value2)));
                }
            }
            if (sourceRequested && !docMapper.sourceMapper().enabled()) {
                sourceRequested = false;
            }
            BytesReference sourceToBeReturned = null;
            if (sourceRequested) {
                sourceToBeReturned = source.source;
                SourceFieldMapper sourceFieldMapper = docMapper.sourceMapper();
                if (sourceFieldMapper.enabled()) {
                    boolean filtered;
                    boolean bl = filtered = sourceFieldMapper.includes().length > 0 || sourceFieldMapper.excludes().length > 0;
                    if (filtered) {
                        Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(source.source, true);
                        Map<String, Object> filteredSource = XContentMapValues.filter(mapTuple.v2(), sourceFieldMapper.includes(), sourceFieldMapper.excludes());
                        try {
                            sourceToBeReturned = XContentFactory.contentBuilder(mapTuple.v1()).map(filteredSource).bytes();
                        }
                        catch (IOException e) {
                            throw new ElasticSearchException("Failed to get type [" + (String)type + "] and id [" + id + "] with includes/excludes set", e);
                        }
                    }
                }
            }
            GetResult getResult = new GetResult(this.shardId.index().name(), (String)type, id, get2.version(), get2.exists(), sourceToBeReturned, fields);
            return getResult;
        }
        finally {
            get2.release();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String type, String id, String[] gFields, Engine.GetResult get2, DocumentMapper docMapper) {
        HashMap<String, GetField> fields = null;
        BytesReference source = null;
        UidField.DocIdAndVersion docIdAndVersion = get2.docIdAndVersion();
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(gFields);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.reader.reader().document(docIdAndVersion.docId, fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticSearchException("Failed to get type [" + type + "] and id [" + id + "]", e);
            }
            source = fieldVisitor.source();
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(docMapper);
                fields = new HashMap<String, GetField>(fieldVisitor.fields().size());
                for (Map.Entry<String, List<Object>> entry2 : fieldVisitor.fields().entrySet()) {
                    fields.put(entry2.getKey(), new GetField(entry2.getKey(), entry2.getValue()));
                }
            }
        }
        if (gFields != null && gFields.length > 0) {
            SearchLookup searchLookup = null;
            for (String field2 : gFields) {
                Object value2 = null;
                if (field2.contains("_source.") || field2.contains("doc[")) {
                    if (searchLookup == null) {
                        searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                    }
                    SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field2, null);
                    searchScript.setNextReader(docIdAndVersion.reader);
                    searchScript.setNextDocId(docIdAndVersion.docId);
                    try {
                        value2 = searchScript.run();
                    }
                    catch (RuntimeException e) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("failed to execute get request script field [{}]", e, field2);
                        }
                    }
                } else {
                    FieldMappers x2 = docMapper.mappers().smartName(field2);
                    if (x2 == null || !x2.mapper().fieldType().stored()) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                            searchLookup.setNextReader(docIdAndVersion.reader);
                            searchLookup.setNextDocId(docIdAndVersion.docId);
                        }
                        if ((value2 = searchLookup.source().extractValue(field2)) != null && x2 != null) {
                            if (value2 instanceof List) {
                                List list2 = (List)value2;
                                for (int i = 0; i < list2.size(); ++i) {
                                    list2.set(i, x2.mapper().valueForSearch(list2.get(i)));
                                }
                            } else {
                                value2 = x2.mapper().valueForSearch(value2);
                            }
                        }
                    }
                }
                if (value2 == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if (value2 instanceof List) {
                    fields.put(field2, new GetField(field2, (List)value2));
                    continue;
                }
                fields.put(field2, new GetField(field2, ImmutableList.of(value2)));
            }
        }
        return new GetResult(this.shardId.index().name(), type, id, get2.version(), get2.exists(), source, fields);
    }

    private static FieldsVisitor buildFieldsVisitors(String ... fields) {
        if (fields == null) {
            return new JustSourceFieldsVisitor();
        }
        if (fields.length == 0) {
            return null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), false);
    }
}

