/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Streamable,
Iterable<GetField>,
ToXContent {
    private String index;
    private String type;
    private String id;
    private long version;
    private boolean exists;
    private Map<String, GetField> fields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    GetResult() {
    }

    public GetResult(String index, String type, String id, long version, boolean exists2, BytesReference source, Map<String, GetField> fields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.version = version;
        this.exists = exists2;
        this.source = source;
        this.fields = fields;
        if (this.fields == null) {
            this.fields = ImmutableMap.of();
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = this.sourceRef().toBytes();
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("failed to decompress source", e);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("failed to convert source to a json string");
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticSearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, GetField> getFields() {
        return this.fields;
    }

    public GetField field(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<GetField> iterator() {
        if (this.fields == null) {
            return Iterators.emptyIterator();
        }
        return this.fields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.EXISTS, this.exists);
        if (this.source != null) {
            RestXContentBuilder.restDocumentSource(this.source, builder, params);
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            builder.startObject(Fields.FIELDS);
            for (GetField field2 : this.fields.values()) {
                if (field2.getValues().isEmpty()) continue;
                if (field2.getValues().size() == 1) {
                    builder.field(field2.getName(), field2.getValues().get(0));
                    continue;
                }
                builder.field(field2.getName());
                builder.startArray();
                for (Object value2 : field2.getValues()) {
                    builder.value(value2);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.isExists()) {
            builder.startObject();
            builder.field(Fields._INDEX, this.index);
            builder.field(Fields._TYPE, this.type);
            builder.field(Fields._ID, this.id);
            builder.field(Fields.EXISTS, false);
            builder.endObject();
        } else {
            builder.startObject();
            builder.field(Fields._INDEX, this.index);
            builder.field(Fields._TYPE, this.type);
            builder.field(Fields._ID, this.id);
            if (this.version != -1L) {
                builder.field(Fields._VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public static GetResult readGetResult(StreamInput in) throws IOException {
        GetResult result2 = new GetResult();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readOptionalString();
        this.id = in.readString();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            int size2;
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if ((size2 = in.readVInt()) == 0) {
                this.fields = ImmutableMap.of();
            } else {
                this.fields = Maps.newHashMapWithExpectedSize(size2);
                for (int i = 0; i < size2; ++i) {
                    GetField field2 = GetField.readGetField(in);
                    this.fields.put(field2.getName(), field2);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.size());
                for (GetField field2 : this.fields.values()) {
                    field2.writeTo(out);
                }
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString EXISTS = new XContentBuilderString("exists");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");

        Fields() {
        }
    }
}

