/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class GetField
implements Streamable,
Iterable<Object> {
    private String name;
    private List<Object> values;

    private GetField() {
    }

    public GetField(String name, List<Object> values2) {
        this.name = name;
        this.values = values2;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.values != null && !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return null;
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static GetField readGetField(StreamInput in) throws IOException {
        GetField result2 = new GetField();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size2 = in.readVInt();
        this.values = new ArrayList<Object>(size2);
        for (int i = 0; i < size2; ++i) {
            this.values.add(in.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.values.size());
        for (Object obj : this.values) {
            out.writeGenericValue(obj);
        }
    }
}

