/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.fs;

import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLockFactory;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.blobstore.fs.AbstractFsBlobContainer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.blobstore.BlobStoreIndexShardGateway;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.threadpool.ThreadPool;

public class FsIndexShardGateway
extends BlobStoreIndexShardGateway {
    private final boolean snapshotLock;

    @Inject
    public FsIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexGateway fsIndexGateway, IndexShard indexShard, Store store) {
        super(shardId, indexSettings, threadPool, fsIndexGateway, indexShard, store);
        this.snapshotLock = indexSettings.getAsBoolean("gateway.fs.snapshot_lock", (Boolean)true);
    }

    @Override
    public String type() {
        return "fs";
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        if (!this.snapshotLock) {
            return NO_SNAPSHOT_LOCK;
        }
        AbstractFsBlobContainer fsBlobContainer = (AbstractFsBlobContainer)((Object)this.blobContainer);
        NativeFSLockFactory lockFactory = new NativeFSLockFactory(fsBlobContainer.filePath());
        Lock lock2 = lockFactory.makeLock("snapshot.lock");
        boolean obtained = lock2.obtain();
        if (!obtained) {
            throw new ElasticSearchIllegalStateException("failed to obtain snapshot lock [" + lock2 + "]");
        }
        return new FsSnapshotLock(lock2);
    }

    public class FsSnapshotLock
    implements IndexShardGateway.SnapshotLock {
        private final Lock lock;

        public FsSnapshotLock(Lock lock2) {
            this.lock = lock2;
        }

        @Override
        public void release() {
            try {
                this.lock.release();
            }
            catch (IOException e) {
                FsIndexShardGateway.this.logger.warn("failed to release snapshot lock [{}]", e, this.lock);
            }
        }
    }
}

