/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public class UidAndRoutingFieldsVisitor
extends FieldsVisitor {
    private String routing;

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if ("_routing".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (UidFieldMapper.NAME.equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.uid != null && this.routing != null ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value2) throws IOException {
        if ("_routing".equals(fieldInfo.name)) {
            this.routing = value2;
        } else {
            super.stringField(fieldInfo, value2);
        }
    }

    public String routing() {
        return this.routing;
    }
}

