/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;

public class SingleFieldsVisitor
extends FieldsVisitor {
    private String field;

    public SingleFieldsVisitor(String field2) {
        this.field = field2;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (fieldInfo.name.equals(this.field)) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void reset(String field2) {
        this.field = field2;
        super.reset();
    }

    public void postProcess(FieldMapper mapper) {
        if (this.fieldsValues == null) {
            return;
        }
        List fieldValues = (List)this.fieldsValues.get(mapper.names().indexName());
        if (fieldValues == null) {
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            fieldValues.set(i, mapper.valueForSearch(fieldValues.get(i)));
        }
    }
}

