/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public abstract class FieldsVisitor
extends StoredFieldVisitor {
    protected BytesReference source;
    protected Uid uid;
    protected Map<String, List<Object>> fieldsValues;

    public void postProcess(MapperService mapperService) {
        DocumentMapper documentMapper;
        if (this.uid != null && (documentMapper = mapperService.documentMapper(this.uid.type())) != null) {
            this.postProcess(documentMapper);
            return;
        }
        for (Map.Entry<String, List<Object>> entry2 : this.fields().entrySet()) {
            FieldMappers fieldMappers = mapperService.indexName(entry2.getKey());
            if (fieldMappers == null) continue;
            List<Object> fieldValues = entry2.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldMappers.mapper().valueForSearch(fieldValues.get(i)));
            }
        }
    }

    public void postProcess(DocumentMapper documentMapper) {
        for (Map.Entry<String, List<Object>> entry2 : this.fields().entrySet()) {
            FieldMapper fieldMapper = documentMapper.mappers().indexName(entry2.getKey()).mapper();
            if (fieldMapper == null) continue;
            List<Object> fieldValues = entry2.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldMapper.valueForSearch(fieldValues.get(i)));
            }
        }
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value2) throws IOException {
        if ("_source".equals(fieldInfo.name)) {
            this.source = new BytesArray(value2);
        } else {
            this.addValue(fieldInfo.name, new BytesRef(value2));
        }
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value2) throws IOException {
        if (UidFieldMapper.NAME.equals(fieldInfo.name)) {
            this.uid = Uid.createUid(value2);
        } else {
            this.addValue(fieldInfo.name, value2);
        }
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value2) throws IOException {
        this.addValue(fieldInfo.name, value2);
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value2) throws IOException {
        this.addValue(fieldInfo.name, value2);
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value2) throws IOException {
        this.addValue(fieldInfo.name, Float.valueOf(value2));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value2) throws IOException {
        this.addValue(fieldInfo.name, value2);
    }

    public BytesReference source() {
        return this.source;
    }

    public Uid uid() {
        return this.uid;
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : ImmutableMap.of();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.uid = null;
    }

    private void addValue(String name, Object value2) {
        List<Object> values2;
        if (this.fieldsValues == null) {
            this.fieldsValues = Maps.newHashMap();
        }
        if ((values2 = this.fieldsValues.get(name)) == null) {
            values2 = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values2);
        }
        values2.add(value2);
    }
}

