/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public class CustomFieldsVisitor
extends FieldsVisitor {
    private final boolean loadAllFields;
    private final boolean loadSource;
    private final Set<String> fields;

    public CustomFieldsVisitor(Set<String> fields, boolean loadSource) {
        this.loadAllFields = false;
        this.loadSource = loadSource;
        this.fields = fields;
    }

    public CustomFieldsVisitor(boolean loadAllFields, boolean loadSource) {
        this.loadAllFields = loadAllFields;
        this.loadSource = loadSource;
        this.fields = null;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.loadAllFields) {
            return StoredFieldVisitor.Status.YES;
        }
        if (this.loadSource && "_source".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (UidFieldMapper.NAME.equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.fields.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }
}

