/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class PagedBytesIndexFieldData
extends AbstractBytesIndexFieldData<PagedBytesAtomicFieldData> {
    public PagedBytesIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedBytesAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return PagedBytesAtomicFieldData.empty(reader.maxDoc());
        }
        PagedBytes bytes = new PagedBytes(15);
        MonotonicAppendingLongBuffer termOrdToBytesOffset = new MonotonicAppendingLongBuffer();
        termOrdToBytesOffset.add(0L);
        long numTerms = this.regex == null && this.frequency == null ? terms.size() : -1L;
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(numTerms, reader.maxDoc(), acceptableTransientOverheadRatio);
        try {
            bytes.copyUsingLengthPrefix(new BytesRef());
            TermsEnum termsEnum = this.filter(terms, reader);
            DocsEnum docsEnum = null;
            BytesRef term = termsEnum.next();
            while (term != null) {
                long termOrd = builder.nextOrdinal();
                assert (termOrd == termOrdToBytesOffset.size());
                termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                docsEnum = termsEnum.docs(null, docsEnum, 0);
                int docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    builder.addDoc(docId);
                    docId = docsEnum.nextDoc();
                }
                term = termsEnum.next();
            }
            long sizePointer = bytes.getPointer();
            PagedBytes.Reader bytesReader = bytes.freeze(true);
            Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
            PagedBytesAtomicFieldData pagedBytesAtomicFieldData = new PagedBytesAtomicFieldData(bytesReader, sizePointer, termOrdToBytesOffset, ordinals);
            return pagedBytesAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<PagedBytesAtomicFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new PagedBytesIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

