/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.EnumSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.PackedArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class PackedArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData<AtomicNumericFieldData> {
    private final IndexNumericFieldData.NumericType numericType;

    public PackedArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, IndexNumericFieldData.NumericType numericType) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Preconditions.checkNotNull(numericType);
        Preconditions.checkArgument(EnumSet.of(IndexNumericFieldData.NumericType.BYTE, IndexNumericFieldData.NumericType.SHORT, IndexNumericFieldData.NumericType.INT, IndexNumericFieldData.NumericType.LONG).contains((Object)numericType), this.getClass().getSimpleName() + " only supports integer types, not " + (Object)((Object)numericType));
        this.numericType = numericType;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return PackedArrayAtomicFieldData.empty(reader.maxDoc());
        }
        MonotonicAppendingLongBuffer values2 = new MonotonicAppendingLongBuffer();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        try {
            BytesRef term;
            boolean indexedAsLong;
            BytesRefIterator iter2 = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator(null)));
            assert (!this.getNumericType().isFloatingPoint());
            boolean bl = indexedAsLong = this.getNumericType().requiredBits() > 32;
            while ((term = iter2.next()) != null) {
                long value2;
                long l = value2 = indexedAsLong ? NumericUtils.prefixCodedToLong(term) : (long)NumericUtils.prefixCodedToInt(term);
                assert (values2.size() == 0L || value2 > values2.get(values2.size() - 1L));
                values2.add(value2);
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                long delta;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long maxValue = 0L;
                long minValue = 0L;
                if (values2.size() > 0L) {
                    minValue = values2.get(0);
                    maxValue = values2.get(values2.size() - 1L);
                }
                long missingValue = 0L;
                if (set != null) {
                    if (maxValue - minValue + 1L == values2.size()) {
                        if (minValue > Long.MIN_VALUE) {
                            missingValue = --minValue;
                        } else {
                            assert (maxValue != Long.MAX_VALUE);
                            missingValue = ++maxValue;
                        }
                    } else {
                        for (long i = 1L; i < values2.size(); ++i) {
                            if (values2.get(i) <= values2.get(i - 1L) + 1L) continue;
                            missingValue = values2.get(i - 1L) + 1L;
                            break;
                        }
                    }
                    missingValue -= minValue;
                }
                int bitsRequired = (delta = maxValue - minValue) < 0L ? 64 : PackedInts.bitsRequired(delta);
                float acceptableOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.2f)).floatValue();
                PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
                long singleValuesSize = (long)formatAndBits.format.longCount(1, reader.maxDoc(), formatAndBits.bitsPerValue) * 8L;
                long uniqueValuesSize = values2.ramBytesUsed();
                if (uniqueValuesSize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesSize) {
                    PackedArrayAtomicFieldData.WithOrdinals withOrdinals = new PackedArrayAtomicFieldData.WithOrdinals(values2, reader.maxDoc(), build);
                    return withOrdinals;
                }
                PackedInts.Mutable sValues = PackedInts.getMutable(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
                if (missingValue != 0L) {
                    sValues.fill(0, sValues.size(), missingValue);
                }
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    long ord = ordinals.getOrd(i);
                    if (ord == 0L) continue;
                    sValues.set(i, values2.get(ord - 1L) - minValue);
                }
                if (set == null) {
                    PackedArrayAtomicFieldData.Single single = new PackedArrayAtomicFieldData.Single(sValues, minValue, reader.maxDoc(), ordinals.getNumOrds());
                    return single;
                }
                PackedArrayAtomicFieldData.SingleSparse singleSparse = new PackedArrayAtomicFieldData.SingleSparse(sValues, minValue, reader.maxDoc(), missingValue, ordinals.getNumOrds());
                return singleSparse;
            }
            PackedArrayAtomicFieldData.WithOrdinals withOrdinals = new PackedArrayAtomicFieldData.WithOrdinals(values2, reader.maxDoc(), build);
            return withOrdinals;
        }
        finally {
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new LongValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private IndexNumericFieldData.NumericType numericType;

        public Builder setNumericType(IndexNumericFieldData.NumericType numericType) {
            this.numericType = numericType;
            return this;
        }

        @Override
        public IndexFieldData<AtomicNumericFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new PackedArrayIndexFieldData(index, indexSettings, fieldNames, type, cache, this.numericType);
        }
    }
}

