/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class PackedArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    private final int numDocs;
    protected long size = -1L;

    public static PackedArrayAtomicFieldData empty(int numDocs) {
        return new Empty(numDocs);
    }

    public PackedArrayAtomicFieldData(int numDocs) {
        super(false);
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    public static class Single
    extends PackedArrayAtomicFieldData {
        private final PackedInts.Mutable values;
        private final long minValue;
        private final long numOrds;

        public Single(PackedInts.Mutable values2, long minValue, int numDocs, long numOrds) {
            super(numDocs);
            this.values = values2;
            this.minValue = minValue;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.minValue);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.minValue);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final PackedInts.Mutable values;
            private final long minValue;

            DoubleValues(PackedInts.Mutable values2, long minValue) {
                super(false);
                this.values = values2;
                this.minValue = minValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public double nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }

        static class LongValues
        extends DenseLongValues {
            private final PackedInts.Mutable values;
            private final long minValue;

            LongValues(PackedInts.Mutable values2, long minValue) {
                super(false);
                this.values = values2;
                this.minValue = minValue;
            }

            @Override
            public long nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }
    }

    public static class SingleSparse
    extends PackedArrayAtomicFieldData {
        private final PackedInts.Mutable values;
        private final long minValue;
        private final long missingValue;
        private final long numOrds;

        public SingleSparse(PackedInts.Mutable values2, long minValue, int numDocs, long missingValue, long numOrds) {
            super(numDocs);
            this.values = values2;
            this.minValue = minValue;
            this.missingValue = missingValue;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed() + 16L;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.minValue, this.missingValue);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.minValue, this.missingValue);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final PackedInts.Mutable values;
            private final long minValue;
            private final long missingValue;

            DoubleValues(PackedInts.Mutable values2, long minValue, long missingValue) {
                super(false);
                this.values = values2;
                this.minValue = minValue;
                this.missingValue = missingValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.values.get(docId) != this.missingValue ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final PackedInts.Mutable values;
            private final long minValue;
            private final long missingValue;

            LongValues(PackedInts.Mutable values2, long minValue, long missingValue) {
                super(false);
                this.values = values2;
                this.minValue = minValue;
                this.missingValue = missingValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.values.get(docId) != this.missingValue ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends PackedArrayAtomicFieldData {
        private final MonotonicAppendingLongBuffer values;
        private final Ordinals ordinals;

        public WithOrdinals(MonotonicAppendingLongBuffer values2, int numDocs, Ordinals ordinals) {
            super(numDocs);
            this.values = values2;
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.values.ramBytesUsed() + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final MonotonicAppendingLongBuffer values;

            DoubleValues(MonotonicAppendingLongBuffer values2, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values2;
            }

            @Override
            public double getValueByOrd(long ord) {
                assert (ord != 0L);
                return this.values.get(ord - 1L);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final MonotonicAppendingLongBuffer values;

            LongValues(MonotonicAppendingLongBuffer values2, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values2;
            }

            @Override
            public long getValueByOrd(long ord) {
                assert (ord != 0L);
                return this.values.get(ord - 1L);
            }
        }
    }

    static class Empty
    extends PackedArrayAtomicFieldData {
        Empty(int numDocs) {
            super(numDocs);
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public long getNumberUniqueValues() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues(boolean needsHashes) {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY;
        }
    }
}

