/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.packed.PagedMutable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class GeoPointCompressedIndexFieldData
extends AbstractGeoPointIndexFieldData {
    private static final String PRECISION_KEY = "precision";
    private static final DistanceUnit.Distance DEFAULT_PRECISION_VALUE = new DistanceUnit.Distance(1.0, DistanceUnit.CENTIMETERS);
    private final GeoPointFieldMapper.Encoding encoding;

    public GeoPointCompressedIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, DistanceUnit.Distance precision) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.encoding = GeoPointFieldMapper.Encoding.of(precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicGeoPointFieldData<ScriptDocValues> loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return new AbstractGeoPointIndexFieldData.Empty(reader.maxDoc());
        }
        long initialSize = terms.size() >= 0L ? 1L + terms.size() : (long)(1 + Math.min(4096, reader.maxDoc()));
        int pageSize = Integer.highestOneBit(131072 / this.encoding.numBitsPerCoordinate() - 1) << 1;
        PagedMutable lat = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        PagedMutable lon = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);
        try {
            GeoPoint point;
            AbstractGeoPointIndexFieldData.GeoPointEnum iter2 = new AbstractGeoPointIndexFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator(null)));
            long ord = 0L;
            while ((point = iter2.next()) != null) {
                if (lat.size() <= ++ord) {
                    long newSize = BigArrays.overSize(ord + 1L);
                    lat = (PagedMutable)lat.resize(newSize);
                    lon = (PagedMutable)lon.resize(newSize);
                }
                lat.set(ord, this.encoding.encodeCoordinate(point.getLat()));
                lon.set(ord, this.encoding.encodeCoordinate(point.getLon()));
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                Ordinals.Docs ordinals = build.ordinals();
                int maxDoc = reader.maxDoc();
                PagedMutable sLat = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                PagedMutable sLon = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                for (int i = 0; i < maxDoc; ++i) {
                    long nativeOrdinal = ordinals.getOrd(i);
                    sLat.set(i, lat.get(nativeOrdinal));
                    sLon.set(i, lon.get(nativeOrdinal));
                }
                FixedBitSet set = builder.buildDocsWithValuesSet();
                if (set == null) {
                    GeoPointCompressedAtomicFieldData.Single single = new GeoPointCompressedAtomicFieldData.Single(this.encoding, sLon, sLat, reader.maxDoc(), ordinals.getNumOrds());
                    return single;
                }
                GeoPointCompressedAtomicFieldData.SingleFixedSet singleFixedSet = new GeoPointCompressedAtomicFieldData.SingleFixedSet(this.encoding, sLon, sLat, reader.maxDoc(), set, ordinals.getNumOrds());
                return singleFixedSet;
            }
            if (lat.size() != build.getMaxOrd()) {
                lat = (PagedMutable)lat.resize(build.getMaxOrd());
                lon = (PagedMutable)lon.resize(build.getMaxOrd());
            }
            GeoPointCompressedAtomicFieldData.WithOrdinals withOrdinals = new GeoPointCompressedAtomicFieldData.WithOrdinals(this.encoding, lon, lat, reader.maxDoc(), build);
            return withOrdinals;
        }
        finally {
            builder.close();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            String precisionAsString = type.getSettings().get(GeoPointCompressedIndexFieldData.PRECISION_KEY);
            DistanceUnit.Distance precision = precisionAsString != null ? DistanceUnit.Distance.parseDistance(precisionAsString, DistanceUnit.METERS) : DEFAULT_PRECISION_VALUE;
            return new GeoPointCompressedIndexFieldData(index, indexSettings, fieldNames, type, cache, precision);
        }
    }
}

