/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigFloatArrayList;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseDoubleValues;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class FloatArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    private final int numDocs;
    protected long size = -1L;

    public static FloatArrayAtomicFieldData empty(int numDocs) {
        return new Empty(numDocs);
    }

    public FloatArrayAtomicFieldData(int numDocs) {
        super(true);
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    public static class Single
    extends FloatArrayAtomicFieldData {
        private final BigFloatArrayList values;
        private final long numOrd;

        public Single(BigFloatArrayList values2, int numDocs, long numOrd) {
            super(numDocs);
            this.values = values2;
            this.numOrd = numOrd;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrd;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.sizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static class DoubleValues
        extends DenseDoubleValues {
            private final BigFloatArrayList values;

            DoubleValues(BigFloatArrayList values2) {
                super(false);
                this.values = values2;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends DenseLongValues {
            private final BigFloatArrayList values;

            LongValues(BigFloatArrayList values2) {
                super(false);
                this.values = values2;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class SingleFixedSet
    extends FloatArrayAtomicFieldData {
        private final BigFloatArrayList values;
        private final FixedBitSet set;
        private final long numOrd;

        public SingleFixedSet(BigFloatArrayList values2, int numDocs, FixedBitSet set, long numOrd) {
            super(numDocs);
            this.values = values2;
            this.set = set;
            this.numOrd = numOrd;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrd;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.sizeInBytes() + RamUsageEstimator.sizeOf(this.set.getBits());
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final BigFloatArrayList values;
            private final FixedBitSet set;

            DoubleValues(BigFloatArrayList values2, FixedBitSet set) {
                super(false);
                this.values = values2;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final BigFloatArrayList values;
            private final FixedBitSet set;

            LongValues(BigFloatArrayList values2, FixedBitSet set) {
                super(false);
                this.values = values2;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends FloatArrayAtomicFieldData {
        private final Ordinals ordinals;
        private final BigFloatArrayList values;

        public WithOrdinals(BigFloatArrayList values2, int numDocs, Ordinals ordinals) {
            super(numDocs);
            this.values = values2;
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.values.sizeInBytes() + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final BigFloatArrayList values;

            DoubleValues(BigFloatArrayList values2, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values2;
            }

            @Override
            public double getValueByOrd(long ord) {
                return this.values.get(ord);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final BigFloatArrayList values;

            LongValues(BigFloatArrayList values2, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values2;
            }

            @Override
            public long getValueByOrd(long ord) {
                assert (ord != 0L);
                return (long)this.values.get(ord);
            }
        }
    }

    static class Empty
    extends FloatArrayAtomicFieldData {
        Empty(int numDocs) {
            super(numDocs);
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return 0L;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues(boolean needsHashes) {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY;
        }
    }
}

