/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.mapper.FieldMapper;

public abstract class AbstractBytesIndexFieldData<FD extends AtomicFieldData.WithOrdinals<ScriptDocValues.Strings>>
extends AbstractIndexFieldData<FD>
implements IndexFieldData.WithOrdinals<FD> {
    protected Settings frequency;
    protected Settings regex;

    protected AbstractBytesIndexFieldData(Index index, Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Map<String, Settings> groups = fieldDataType.getSettings().getGroups("filter");
        this.frequency = groups.get("frequency");
        this.regex = groups.get("regex");
    }

    @Override
    public final boolean valuesOrdered() {
        return true;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode);
    }

    protected TermsEnum filter(Terms terms, AtomicReader reader) throws IOException {
        TermsEnum iterator2 = terms.iterator(null);
        if (iterator2 == null) {
            return null;
        }
        if (iterator2 != null && this.frequency != null) {
            iterator2 = FrequencyFilter.filter(iterator2, terms, reader, this.frequency);
        }
        if (iterator2 != null && this.regex != null) {
            iterator2 = RegexFilter.filter(iterator2, terms, reader, this.regex);
        }
        return iterator2;
    }

    private static final class RegexFilter
    extends FilteredTermsEnum {
        private final Matcher matcher;
        private final CharsRef spare = new CharsRef();

        public RegexFilter(TermsEnum delegate, Matcher matcher) {
            super(delegate, false);
            this.matcher = matcher;
        }

        public static TermsEnum filter(TermsEnum iterator2, Terms terms, AtomicReader reader, Settings regex) {
            String pattern = regex.get("pattern");
            if (pattern == null) {
                return iterator2;
            }
            Pattern p = Pattern.compile(pattern);
            return new RegexFilter(iterator2, p.matcher(""));
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            UnicodeUtil.UTF8toUTF16(arg0, this.spare);
            this.matcher.reset(this.spare);
            if (this.matcher.matches()) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    private static final class FrequencyFilter
    extends FilteredTermsEnum {
        private int minFreq;
        private int maxFreq;

        public FrequencyFilter(TermsEnum delegate, int minFreq, int maxFreq) {
            super(delegate, false);
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
        }

        public static TermsEnum filter(TermsEnum toFilter, Terms terms, AtomicReader reader, Settings settings) throws IOException {
            int docCount = terms.getDocCount();
            if (docCount == -1) {
                docCount = reader.maxDoc();
            }
            double minFrequency = settings.getAsDouble("min", (Double)0.0);
            double maxFrequency = settings.getAsDouble("max", (Double)((double)docCount + 1.0));
            double minSegmentSize = settings.getAsInt("min_segment_size", (Integer)0).intValue();
            if (minSegmentSize < (double)docCount) {
                int maxFreq;
                int minFreq = minFrequency >= 1.0 ? (int)minFrequency : (int)((double)docCount * minFrequency);
                int n = maxFreq = maxFrequency >= 1.0 ? (int)maxFrequency : (int)((double)docCount * maxFrequency);
                assert (minFreq < maxFreq);
                return new FrequencyFilter(toFilter, minFreq, maxFreq);
            }
            return toFilter;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            int docFreq = this.docFreq();
            if (docFreq >= this.minFreq && docFreq <= this.maxFreq) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }
}

