/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class SinglePackedOrdinals
implements Ordinals {
    private final PackedInts.Reader reader;
    private final long numOrds;
    private final long maxOrd;
    private long size = -1L;

    public SinglePackedOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        assert (builder.getNumMultiValuesDocs() == 0);
        this.numOrds = builder.getNumOrds();
        this.maxOrd = builder.getNumOrds() + 1L;
        PackedInts.Mutable reader = PackedInts.getMutable(builder.maxDoc(), PackedInts.bitsRequired(this.getNumOrds()), acceptableOverheadRatio);
        PackedInts.copy(builder.getFirstOrdinals(), 0, reader, 0, builder.maxDoc(), 8192);
        this.reader = reader;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            this.size = (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.reader.size();
    }

    @Override
    public long getNumOrds() {
        return this.numOrds;
    }

    @Override
    public long getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.reader);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final SinglePackedOrdinals parent;
        private final PackedInts.Reader reader;
        private final LongsRef longsScratch = new LongsRef(1);
        private long currentOrdinal;

        public Docs(SinglePackedOrdinals parent, PackedInts.Reader reader) {
            this.parent = parent;
            this.reader = reader;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public long getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public long getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getOrd(int docId) {
            this.currentOrdinal = this.reader.get(docId);
            return this.currentOrdinal;
        }

        @Override
        public LongsRef getOrds(int docId) {
            long ordinal = this.reader.get(docId);
            this.longsScratch.offset = 0;
            this.longsScratch.length = (int)Math.min(this.currentOrdinal, 1L);
            this.longsScratch.longs[0] = this.currentOrdinal = ordinal;
            return this.longsScratch;
        }

        @Override
        public long nextOrd() {
            assert (this.currentOrdinal > 0L);
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            this.currentOrdinal = this.reader.get(docId);
            return (int)Math.min(this.currentOrdinal, 1L);
        }

        @Override
        public long currentOrd() {
            return this.currentOrdinal;
        }
    }
}

