/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.LongsRef;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class EmptyOrdinals
implements Ordinals {
    private final int numDocs;

    public EmptyOrdinals(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public long getMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public long getNumOrds() {
        return 0L;
    }

    @Override
    public long getMaxOrd() {
        return 1L;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final EmptyOrdinals parent;
        public static final LongsRef EMPTY_LONGS_REF = new LongsRef();

        public Docs(EmptyOrdinals parent) {
            this.parent = parent;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public long getNumOrds() {
            return 0L;
        }

        @Override
        public long getMaxOrd() {
            return 1L;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getOrd(int docId) {
            return 0L;
        }

        @Override
        public LongsRef getOrds(int docId) {
            return EMPTY_LONGS_REF;
        }

        @Override
        public long nextOrd() {
            throw new ElasticSearchIllegalStateException("Empty ordinals has no nextOrd");
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public long currentOrd() {
            return 0L;
        }
    }
}

