/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;

public enum SortMode {
    SUM{

        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public long apply(long a, long b) {
            return a + b;
        }
    }
    ,
    AVG{

        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public long apply(long a, long b) {
            return a + b;
        }

        @Override
        public double reduce(double a, int numValues) {
            return a / Math.max(1.0, (double)numValues);
        }

        @Override
        public long reduce(long a, int numValues) {
            return Math.round((double)a / Math.max(1.0, (double)numValues));
        }
    }
    ,
    MIN{

        @Override
        public double apply(double a, double b) {
            return Math.min(a, b);
        }

        @Override
        public long apply(long a, long b) {
            return Math.min(a, b);
        }

        @Override
        public double startDouble() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public long startLong() {
            return Long.MAX_VALUE;
        }

        @Override
        public double getRelevantValue(DoubleValues values2, int docId, double defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            if (values2.setDocument(docId) > 0) {
                return values2.nextValue();
            }
            return defaultValue;
        }

        @Override
        public long getRelevantValue(LongValues values2, int docId, long defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            if (values2.setDocument(docId) > 0) {
                return values2.nextValue();
            }
            return defaultValue;
        }

        @Override
        public BytesRef getRelevantValue(BytesValues values2, int docId, BytesRef defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            if (values2.setDocument(docId) > 0) {
                return values2.nextValue();
            }
            return defaultValue;
        }
    }
    ,
    MAX{

        @Override
        public double apply(double a, double b) {
            return Math.max(a, b);
        }

        @Override
        public long apply(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        public double startDouble() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public long startLong() {
            return Long.MIN_VALUE;
        }

        @Override
        public double getRelevantValue(DoubleValues values2, int docId, double defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            int numValues = values2.setDocument(docId);
            double retVal = defaultValue;
            for (int i = 0; i < numValues; ++i) {
                retVal = values2.nextValue();
            }
            return retVal;
        }

        @Override
        public long getRelevantValue(LongValues values2, int docId, long defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            int numValues = values2.setDocument(docId);
            long retVal = defaultValue;
            for (int i = 0; i < numValues; ++i) {
                retVal = values2.nextValue();
            }
            return retVal;
        }

        @Override
        public BytesRef getRelevantValue(BytesValues values2, int docId, BytesRef defaultValue) {
            assert (values2.getOrder() != AtomicFieldData.Order.NONE);
            int numValues = values2.setDocument(docId);
            BytesRef currentVal = defaultValue;
            for (int i = 0; i < numValues; ++i) {
                currentVal = values2.nextValue();
            }
            return currentVal;
        }
    };


    public abstract double apply(double var1, double var3);

    public abstract long apply(long var1, long var3);

    public double startDouble() {
        return 0.0;
    }

    public long startLong() {
        return 0L;
    }

    public double reduce(double a, int numValues) {
        return a;
    }

    public long reduce(long a, int numValues) {
        return a;
    }

    public static SortMode fromString(String sortMode) {
        try {
            return SortMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Throwable t) {
            throw new ElasticSearchIllegalArgumentException("Illegal sort_mode " + sortMode);
        }
    }

    public double getRelevantValue(DoubleValues values2, int docId, double defaultValue) {
        int numValues = values2.setDocument(docId);
        double relevantVal = this.startDouble();
        double result2 = defaultValue;
        for (int i = 0; i < numValues; ++i) {
            result2 = relevantVal = this.apply(relevantVal, values2.nextValue());
        }
        return this.reduce(result2, numValues);
    }

    public long getRelevantValue(LongValues values2, int docId, long defaultValue) {
        int numValues = values2.setDocument(docId);
        long relevantVal = this.startLong();
        long result2 = defaultValue;
        for (int i = 0; i < numValues; ++i) {
            result2 = relevantVal = this.apply(relevantVal, values2.nextValue());
        }
        return this.reduce(result2, numValues);
    }

    public BytesRef getRelevantValue(BytesValues values2, int docId, BytesRef defaultValue) {
        throw new UnsupportedOperationException("no relevant bytes value for sort mode: " + this.name());
    }
}

