/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.ShortValuesComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class ShortValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData<?> indexFieldData;
    private final Object missingValue;
    private final SortMode sortMode;

    public ShortValuesComparatorSource(IndexNumericFieldData<?> indexFieldData, @Nullable Object missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed2) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        short dMissingValue = this.missingValue == null || "_last".equals(this.missingValue) ? (reversed2 ? (short)Short.MIN_VALUE : Short.MAX_VALUE) : ("_first".equals(this.missingValue) ? (reversed2 ? (short)Short.MAX_VALUE : Short.MIN_VALUE) : (this.missingValue instanceof Number ? ((Number)this.missingValue).shortValue() : Short.parseShort(this.missingValue.toString())));
        return new ShortValuesComparator(this.indexFieldData, dMissingValue, numHits, this.sortMode);
    }
}

