/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class ShortValuesComparator
extends LongValuesComparatorBase<Short> {
    private final short[] values;
    private final SortMode sortMode;

    public ShortValuesComparator(IndexNumericFieldData<?> indexFieldData, short missingValue, int numHits, SortMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        assert (indexFieldData.getNumericType().requiredBits() <= 16);
        this.values = new short[numHits];
        this.sortMode = sortMode;
    }

    @Override
    public int compare(int slot1, int slot2) {
        short v1 = this.values[slot1];
        short v2 = this.values[slot2];
        return v1 - v2;
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = (short)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public Short value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = (short)(this.values[n] + (short)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue));
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = (short)(this.values[n] / divisor);
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = (short)this.missingValue;
    }
}

